package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by pavryabov on 14.03.16.
 * https://st.yandex-team.ru/TESTIRT-8642
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + AdExtensionIds)")
@Issue("https://st.yandex-team.ru/DIRECT-50728")
public class IdsWithAdExtensionIdsFilterTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long firstAdWithAdExtensionId1;
    static Long secondAdWithAdExtensionId1;
    static Long adWithAdExtensionId2;
    static Long adWithBothAdExtensionIds;
    static Long adExtensionId1;
    static Long adExtensionId2;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adExtensionId1 = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adExtensionId2 = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        firstAdWithAdExtensionId1 = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId1)).withAdGroupId(adGroupId));
        secondAdWithAdExtensionId1 = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId1)).withAdGroupId(adGroupId));
        adWithBothAdExtensionIds = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId1, adExtensionId2)).withAdGroupId(adGroupId));
        adWithAdExtensionId2 = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdExtensionIds(adExtensionId2)).withAdGroupId(adGroupId));
    }

    @Test
    public void getAdExtensionIdWithTwoAdsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithAdExtensionId1)
                        .withAdExtensionIds(adExtensionId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithAdExtensionId1).getBean())));
    }

    @Test
    public void getAdExtensionIdWithOtherAdAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithAdExtensionId1)
                        .withAdExtensionIds(adExtensionId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdExtensionIdAndTwoAds() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithAdExtensionId1, adWithAdExtensionId2)
                        .withAdExtensionIds(adExtensionId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithAdExtensionId1).getBean())));
    }

    @Test
    public void getTwoAdExtensionIdsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithAdExtensionId1)
                        .withAdExtensionIds(adExtensionId1, adExtensionId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithAdExtensionId1).getBean())));
    }

    @Test
    public void getTwoAdExtensionIdsAndAdWithBothAdExtensions() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithBothAdExtensionIds)
                        .withAdExtensionIds(adExtensionId1, adExtensionId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adWithBothAdExtensionIds).getBean())));
    }
}
