package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by pavryabov on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + AdGroupIds)")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class IdsWithAdGroupIdsFilterTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId1;
    private static Long adGroupId2;
    private static Long firstAdFromAdGroup1;
    private static Long adFromAdGroup2;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        firstAdFromAdGroup1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adFromAdGroup2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);
    }

    @Test
    public void getAdGroupWithTwoAdsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdFromAdGroup1)
                        .withAdGroupIds(adGroupId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdFromAdGroup1).getBean())));
    }

    @Test
    public void getAdGroupWithOtherAdAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdFromAdGroup1)
                        .withAdGroupIds(adGroupId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdGroupAndTwoAds() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdFromAdGroup1, adFromAdGroup2)
                        .withAdGroupIds(adGroupId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdFromAdGroup1).getBean())));
    }

    @Test
    public void getTwoAdGroupsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdFromAdGroup1)
                        .withAdGroupIds(adGroupId1, adGroupId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdFromAdGroup1).getBean())));
    }
}
