package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 16.07.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + SitelinksModerationStatuses)")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class IdsWithSitelinksModerationStatusesFilterTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adWithDraftSitelinks;
    private static Long adWithModerationSitelinks;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long draftSitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long moderationSitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adWithDraftSitelinks = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withSitelinkSetId(draftSitelinkSetId)).withAdGroupId(adGroupId));
        adWithModerationSitelinks = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withSitelinkSetId(moderationSitelinkSetId)).withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setStatusSitelinksModerate(adWithModerationSitelinks, Status.SENT);
    }

    @Test
    public void getAdAndOtherStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftSitelinks)
                        .withSitelinksModerationStatuses(ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftSitelinks)
                        .withSitelinksModerationStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adWithDraftSitelinks).getBean())));
    }

    @Test
    public void getTwoAdsAndStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftSitelinks, adWithModerationSitelinks)
                        .withSitelinksModerationStatuses(ExtensionStatusSelectionEnum.DRAFT))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adWithDraftSitelinks).getBean())));
    }

    @Test
    public void getTwoAdsAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftSitelinks, adWithModerationSitelinks)
                        .withSitelinksModerationStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(adWithDraftSitelinks).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adWithModerationSitelinks).getBean())));
    }
}
