package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.BsDeadDomainsHelper;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + States)")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class IdsWithStatesFilterTest {
    private static final String ALIVE_DOMAIN = "alivetestdomain.xx";
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long onAd;
    private static Long offAd;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        int shard =  api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(client);
        BsDeadDomainsHelper.removeFromBsDeadDomains(shard, api.userSteps.getDirectJooqDbSteps(), ALIVE_DOMAIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        api.userSteps.campaignFakeSteps().setStatusActive(campaignId, Status.YES);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        onAd = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withHref("http://" + ALIVE_DOMAIN))
                        .withAdGroupId(adGroupId));
        offAd = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap()
                        .defaultTextAd()
                        .withHref("http://" + ALIVE_DOMAIN))
                .withAdGroupId(adGroupId));

        api.userSteps.bannersFakeSteps().setStatusShow(onAd, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusActive(onAd, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusShow(offAd, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusActive(offAd, Status.NO);
    }

    @Test
    public void getAdAndOtherState() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd)
                        .withStates(AdStateSelectionEnum.OFF))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdAndTwoStates() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd)
                        .withStates(AdStateSelectionEnum.ON, AdStateSelectionEnum.OFF))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(onAd).getBean())));
    }

    @Test
    public void getTwoAdsAndState() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd, offAd)
                        .withStates(AdStateSelectionEnum.ON))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(onAd).getBean())));
    }

    @Test
    public void getTwoAdsAndTwoStates() {
        //DIRECT-48188
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd, offAd)
                        .withStates(AdStateSelectionEnum.ON, AdStateSelectionEnum.OFF))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(onAd).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(offAd).getBean())));
    }

    @Test
    public void getTwoAdsAndTwoStatesAndOtherStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd, offAd)
                        .withStates(AdStateSelectionEnum.ON, AdStateSelectionEnum.OFF)
                        .withStatuses(AdStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getTwoAdsAndTwoStatesAndOtherStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(onAd, offAd)
                        .withStates(AdStateSelectionEnum.ON, AdStateSelectionEnum.OFF)
                        .withStatuses(AdStatusSelectionEnum.MODERATION, AdStatusSelectionEnum.ACCEPTED))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }
}
