package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + Types)")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class IdsWithTypesFilterTest {

    private static String client = AdsLogins.CLIENT42;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long textAdGroupId;
    static Long textAd;
    static Long dynamicTextAd;
    static Long textImageAdId;
    static Long cpcVideoAdId;
    static Long mobileAppImageAdId;
    static Long mobileAppCpcVideoAdId;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        textAd = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupId);
        Long dynamicTextcampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextcampaignId);
        dynamicTextAd = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(2);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(textAdGroupId, adImageHash);
        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);

        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(client).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(client).getClientID()));
        cpcVideoAdId = api.userSteps.adsSteps()
                .addDefaultCpcVideoAdBuilderAd(textAdGroupId, creativeId);

        mobileAppCpcVideoAdId = api.userSteps.adsSteps()
                .addDefaultMobileAppCpcVideoAdBuilderAd(mobileAppAdGroupId, creativeId);
    }

    @Test
    public void getAdAndOtherType() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd)
                        .withTypes(AdTypeEnum.DYNAMIC_TEXT_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdAndTwoTypes() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd)
                        .withTypes(AdTypeEnum.TEXT_AD, AdTypeEnum.DYNAMIC_TEXT_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(textAd).getBean())));
    }

    @Test
    public void getTwoAdsAndType() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd, dynamicTextAd)
                        .withTypes(AdTypeEnum.TEXT_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(textAd).getBean())));
    }

    @Test
    public void getTwoAdsAndTwoTypes() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd, dynamicTextAd)
                        .withTypes(AdTypeEnum.TEXT_AD, AdTypeEnum.DYNAMIC_TEXT_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(textAd).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(dynamicTextAd).getBean())));
    }

    @Test
    public void getTwoImageAdAdsWithImageAdType() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textImageAdId, mobileAppImageAdId)
                        .withTypes(AdTypeEnum.IMAGE_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(textImageAdId).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(mobileAppImageAdId).getBean())));
    }

    @Test
    public void getCpcVideoAdByFilter() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd, cpcVideoAdId)
                        .withTypes(AdTypeEnum.CPC_VIDEO_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(cpcVideoAdId).getBean())));
    }

    @Test
    public void getMobileAppCpcVideoAdByFilter() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd, mobileAppCpcVideoAdId)
                        .withTypes(AdTypeEnum.CPC_VIDEO_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(mobileAppCpcVideoAdId).getBean())));
    }

    @Test
    public void getImageAdAndTextAdWithImageAdType() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textAd, textImageAdId)
                        .withTypes(AdTypeEnum.IMAGE_AD))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(textImageAdId).getBean())));
    }

    @Test
    public void getAdsFromTextAdGroup() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withAdGroupIds(textAdGroupId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                                .withId(textAd)
                                .withType(AdTypeEnum.TEXT_AD).getBean(),
                        (AdGetItem) new AdGetItemMap()
                                .withId(textImageAdId)
                                .withType(AdTypeEnum.IMAGE_AD).getBean(),
                        (AdGetItem) new AdGetItemMap()
                                .withId(cpcVideoAdId)
                                .withType(AdTypeEnum.CPC_VIDEO_AD).getBean())));
    }
}
