package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by pavryabov on 21.05.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + VCardIds)")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class IdsWithVCardIdsFilterTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long firstAdWithVCard1;
    private static Long adWithVCard2;
    private static Long vCardId1;
    private static Long vCardId2;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        vCardId1 = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        vCardId2 = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        firstAdWithVCard1 = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(vCardId1)).withAdGroupId(adGroupId));
        api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(vCardId1)).withAdGroupId(adGroupId));
        adWithVCard2 = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(vCardId2)).withAdGroupId(adGroupId));
    }

    @Test
    public void getVCardWithTwoAdsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithVCard1)
                        .withVCardIds(vCardId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithVCard1).getBean())));
    }

    @Test
    public void getVCardWithOtherAdAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithVCard1)
                        .withVCardIds(vCardId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getVCardAndTwoAds() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithVCard1, adWithVCard2)
                        .withVCardIds(vCardId1))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithVCard1).getBean())));
    }

    @Test
    public void getTwoVCardsAndAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(firstAdWithVCard1)
                        .withVCardIds(vCardId1, vCardId2))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(firstAdWithVCard1).getBean())));
    }
}
