package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 16.07.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + VCardModerationStatuses)")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class IdsWithVCardModerationStatusesFilterTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adWithDraftVCard;
    private static Long adWithModerationVCard;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long draftVCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long moderationVCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adWithDraftVCard = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(draftVCardId)).withAdGroupId(adGroupId));
        adWithModerationVCard = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(moderationVCardId)).withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setPhoneflag(adWithModerationVCard, Status.SENT);
    }

    @Test
    public void getAdAndOtherStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftVCard)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    public void getAdAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftVCard)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adWithDraftVCard).getBean())));
    }

    @Test
    public void getTwoAdsAndStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftVCard, adWithModerationVCard)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.DRAFT))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adWithDraftVCard).getBean())));
    }

    @Test
    public void getTwoAdsAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adWithDraftVCard, adWithModerationVCard)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.DRAFT, ExtensionStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(adWithDraftVCard).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(adWithModerationVCard).getBean())));
    }
}
