package ru.yandex.autotests.direct.api.ads.get;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Неправильный формат запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class InvalidJSONTest {

    private static String client = AdsLogins.CLIENT;
    private static final String PARAMS = "params";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(GetRequestMap.SELECTION_CRITERIA, selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        GetRequestMap.SELECTION_CRITERIA)
        );
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        selectionCriteria.put(AdsSelectionCriteriaMap.IDS, new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), AdsSelectionCriteriaMap.IDS)
                                .collect(joining(".")))
        );
    }

    @Test
    public void invalidFieldInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        page.put(LimitOffsetMap.LIMIT, 1L);
        request.put(capitalize(GetRequestMap.PAGE), page);
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        Stream.of(capitalize(GetRequestMap.PAGE), LimitOffsetMap.LIMIT).collect(joining(".")))
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.SELECTION_CRITERIA))
        );
    }

    @Test
    public void arrayInPage() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        JSONObject page = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        page.put(capitalize(LimitOffsetMap.LIMIT), 1L);
        request.put(capitalize(GetRequestMap.PAGE), new Object[]{page});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.PAGE))
        );
    }
}
