package ru.yandex.autotests.direct.api.ads.get;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Неправильный запрос")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class InvalidRequestTest {
    private static final String CLIENT = AdsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void emptySelectionCriteria() {
        //DIRECT-41546
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap())
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(4001, Api5ErrorDetails.NO_FIELDS_IN_SELECTION_CRITERIA));
    }

    @Test
    public void emptyArraysInSelectionCriteria() {
        //DIRECT-41547
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap()
                                .withIds()
                                .withAdGroupIds()
                                .withCampaignIds(new Long[]{})
                                .withStates(new AdStateSelectionEnum[]{})
                                .withStatuses(new AdStatusSelectionEnum[]{})
                                .withTypes(new AdTypeEnum[]{})
                                .withVCardIds()
                                .withSitelinkSetIds()
                                .withAdImageHashes()
                                .withVCardModerationStatuses(new ExtensionStatusSelectionEnum[]{})
                                .withSitelinksModerationStatuses(new ExtensionStatusSelectionEnum[]{})
                                .withAdImageModerationStatuses(new ExtensionStatusSelectionEnum[]{})
                        )
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(4001, Api5ErrorDetails.NO_FIELDS_IN_SELECTION_CRITERIA));
    }

    @Test
    public void emptyArrayOfFieldNames() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(new AdFieldEnum[]{}),
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        path(GetRequestMap.FIELD_NAMES), 1));
    }

    @Test
    public void emptyArrayOfTextAdFieldNames() {
        //DIRECT-41547
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(new TextAdFieldEnum[]{}));
        assertThat("вернулось одно объявление", getResponse.getAds(), hasSize(1));
    }
}
