package ru.yandex.autotests.direct.api.ads.get;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Неправильные типы в простых полях")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class InvalidTypesOfFieldsTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), adId);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.IDS))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfStringInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new String[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.IDS))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.IDS))
        );
    }

    @Test
    public void notArrayInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.STATES), StateEnum.ON);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.STATES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInStates() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.STATES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.STATES))
        );
    }

    @Test
    public void notArrayInStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.STATUSES), StatusEnum.DRAFT);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.STATUSES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.STATUSES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.STATUSES))
        );
    }

    @Test
    public void notArrayInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS), campaignId);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfStringInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS), new String[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInCampaignIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS))
        );
    }

    @Test
    public void notArrayInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS), adId);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfStringInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS), new String[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInAdGroupIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS))
        );
    }

    @Test
    public void notArrayInTypes() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.TYPES), AdTypeEnum.TEXT_AD);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.TYPES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInTypes() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.TYPES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.TYPES))
        );
    }

    @Test
    public void notArrayInVCardIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.VCARD_IDS), adId);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.VCARD_IDS))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfStringInVCardIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.VCARD_IDS), new String[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.VCARD_IDS))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInVCardIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.VCARD_IDS), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.VCARD_IDS))
        );
    }

    @Test
    public void notArrayInSitelinkSetIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS), adId);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfStringInSitelinkSetIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS), new String[]{"value"});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInSitelinkSetIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.SITELINK_SET_IDS))
        );
    }

    @Test
    public void notArrayInAdImageHashesIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES), "hash");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES))
                                        .collect(joining("."))));
    }

    @Test
    public void arrayOfArraysInAdImageHashesIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES), new String[][]{{"value"}});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_STRING,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInAdImageHashesIds() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.ADIMAGE_HASHES))
        );
    }

    @Test
    public void notArrayInVCardModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.VCARD_MODERATION_STATUSES), StatusEnum.DRAFT);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.VCARD_MODERATION_STATUSES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInVCardModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.VCARD_MODERATION_STATUSES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.VCARD_MODERATION_STATUSES))
        );
    }

    @Test
    public void notArrayInSitelinksModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.SITELINKS_MODERATION_STATUSES), StatusEnum.DRAFT);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.SITELINKS_MODERATION_STATUSES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInSitelinksModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.SITELINKS_MODERATION_STATUSES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.SITELINKS_MODERATION_STATUSES))
        );
    }

    @Test
    public void notArrayInAdImageModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADIMAGE_MODERATION_STATUSES), StatusEnum.DRAFT);
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.ADIMAGE_MODERATION_STATUSES))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInAdImageModerationStatuses() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.ADIMAGE_MODERATION_STATUSES), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.ADIMAGE_MODERATION_STATUSES))
        );
    }

    @Test
    public void notArrayInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), AdFieldEnum.ID);
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_ARRAY,
                                capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), "null");
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES))
        );
    }

    @Test
    public void notArrayInTextAdFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.TEXT_AD_FIELD_NAMES), TextAdFieldEnum.HREF);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.TEXT_AD_FIELD_NAMES))
        );
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInTextAdFieldNames() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.IDS), new Long[]{adId});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        request.put(capitalize(GetRequestMap.TEXT_AD_FIELD_NAMES), "null");
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(GetRequestMap.TEXT_AD_FIELD_NAMES))
        );
    }

    @Test
    public void arrayInMobile() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.MOBILE), new Object[]{YesNoEnum.NO});
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_NOT_CONTAIN_ARRAY,
                                Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA), capitalize(AdsSelectionCriteriaMap.MOBILE))
                                        .collect(joining("."))));
    }

    @Test
    @Ignore("DIRECT-88338")
    public void nullInMobile() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.MOBILE), "null");
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdsSelectionCriteriaMap.MOBILE))
        );
    }
}
