package ru.yandex.autotests.direct.api.ads.get;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.joining;
import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Неправильные значения в полях, принимающих Enum'ы")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class InvalidValuesInEnumsTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void invalidValueInStates() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withStates(uncapitalize(StateEnum.ON.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.STATES))
                                .collect(joining(".")),
                        "OFF, ON, SUSPENDED, OFF_BY_MONITORING, ARCHIVED"));
    }

    @Test
    public void invalidValueInStatuses() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withStatuses(uncapitalize(StatusEnum.DRAFT.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.STATUSES))
                                .collect(joining(".")),
                        "DRAFT, MODERATION, PREACCEPTED, ACCEPTED, REJECTED"));
    }

    @Test
    public void invalidValueInTypes() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withTypes(uncapitalize(AdTypeEnum.TEXT_AD.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.TYPES))
                                .collect(joining(".")), "TEXT_AD, MOBILE_APP_AD, CPC_VIDEO_AD, " +
                        "DYNAMIC_TEXT_AD, IMAGE_AD, CPM_BANNER_AD, CPM_VIDEO_AD, SMART_AD, " +
                        "CONTENT_PROMOTION_VIDEO_AD, CONTENT_PROMOTION_COLLECTION_AD, CONTENT_PROMOTION_SERVICE_AD, " +
                        "CONTENT_PROMOTION_EDA_AD"));
    }

    @Test
    public void invalidValueInVCardModerationStatuses() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withVCardModerationStatuses(uncapitalize(StatusEnum.DRAFT.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.VCARD_MODERATION_STATUSES))
                                .collect(joining(".")),
                        "DRAFT, MODERATION, ACCEPTED, REJECTED"));
    }

    @Test
    public void invalidValueInSitelinksModerationStatuses() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withSitelinksModerationStatuses(uncapitalize(StatusEnum.DRAFT.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.SITELINKS_MODERATION_STATUSES))
                                .collect(joining(".")),
                        "DRAFT, MODERATION, ACCEPTED, REJECTED"));
    }

    @Test
    public void invalidValueInAdImageModerationStatuses() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withAdImageModerationStatuses(uncapitalize(StatusEnum.DRAFT.toString())))
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.ADIMAGE_MODERATION_STATUSES))
                                .collect(joining(".")),
                        "DRAFT, MODERATION, ACCEPTED, REJECTED"));
    }

    @Test
    public void invalidValueInFieldNames() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(uncapitalize(AdFieldEnum.ID.toString())),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        "AdCategories, AgeLabel, AdGroupId, CampaignId, Id, State, Status, StatusClarification, Type, Subtype"));
    }

    @Test
    public void invalidValueInTextAdFieldNames() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withIds(adId))
                        .withFieldNames(AdFieldEnum.ID)
                        .withTextAdFieldNames(uncapitalize(TextAdFieldEnum.HREF.toString())),
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.TEXT_AD_FIELD_NAMES),
                        // Api5Error.enumAsParam(TextAdFieldEnum.class)));
                        //
                        // Дифф с публичной wsdl:
                        //   https://st.yandex-team.ru/DIRECT-126092
                        //    - TrackingPhoneId
                        //   https://st.yandex-team.ru/DIRECT-122975
                        //    - LogoExtensionHash
                        //    - LogoExtensionModeration
                        //    - ButtonExtension
                        //    - ButtonExtensionModeration
                        //   https://st.yandex-team.ru/DIRECT-142656
                        //    - DutPrefix
                        //    - DutSuffix
                        "AdImageHash, LogoExtensionHash, LogoExtensionModeration, DisplayDomain, Href, " +
                                "SitelinkSetId, Text, Title, Title2, Mobile, VCardId, " +
                                "DisplayUrlPath, DutPrefix, DutSuffix, AdImageModeration, SitelinksModeration, " +
                                "VCardModeration, AdExtensions, DisplayUrlPathModeration, VideoExtension, " +
                                "TurboPageId, TurboPageModeration, ButtonExtensionModeration, BusinessId, " +
                                "TrackingPhoneId, PreferVCardOverBusiness, ButtonExtension, LfHref, LfButtonText"));
    }

    @Test
    public void invalidValueInMobile() {
        JSONObject request = new JSONObject();
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdsSelectionCriteriaMap.MOBILE), uncapitalize(YesNoEnum.NO.toString()));
        request.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        request.put(capitalize(GetRequestMap.FIELD_NAMES), new Object[]{AdFieldEnum.ID});
        api.userSteps.adsSteps().expectErrorOnAdsGet(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        Stream.of(capitalize(GetRequestMap.SELECTION_CRITERIA),
                                capitalize(AdsSelectionCriteriaMap.MOBILE))
                                .collect(joining(".")),
                        "YES, NO"));
    }
}
