package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 26.06.15.
 * https://st.yandex-team.ru/TESTIRT-6079
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля Mobile в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-42167")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class MobileTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameterized.Parameter(0)
    public YesNoEnum mobile;

    @Parameterized.Parameters(name = "mobile = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {YesNoEnum.NO},
                {YesNoEnum.YES}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap()
                        .withText(TextAdAddMap.DEFAULT_TEXT)
                        .withTitle(TextAdAddMap.DEFAULT_TITLE)
                        .withHref(TextAdAddMap.DEFAULT_HREF)
                        .withMobile(mobile))
                .withAdGroupId(adGroupId));
    }

    @Test
    public void getAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId).withMobile(mobile))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.MOBILE));
        assertThat("Вернулся правильный State", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap().withMobile(mobile)).getBean())));
    }
}
