package ru.yandex.autotests.direct.api.ads.get;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка обязательности указания полей")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class RequiredFieldsTest {

    private static String client = AdsLogins.CLIENT;
    private static final String PARAMS = "params";


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void getWithoutSelectionCriteria() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap().withFieldNames(AdFieldEnum.ID),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(GetRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void getWithoutFieldNames() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap()
                        .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId)),
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(GetRequestMap.FIELD_NAMES)));
    }

    @Test
    public void getWithoutAnyIdsInSelectionCriteria() {
        api.userSteps.adsSteps().expectErrorOnAdsGet(new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withStates(AdStateSelectionEnum.OFF)
                                        .withStatuses(AdStatusSelectionEnum.DRAFT)
                                        .withTypes(AdTypeEnum.TEXT_AD)
                                        .withVCardIds(1L)
                                        .withSitelinkSetIds(1L)
                                        .withAdExtensionIds(1L)
                                        .withAdImageHashes("1111111")
                                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.DRAFT)
                                        .withSitelinksModerationStatuses(ExtensionStatusSelectionEnum.DRAFT)
                                        .withAdImageModerationStatuses(ExtensionStatusSelectionEnum.DRAFT)
                                        .withMobile(YesNoEnum.NO)
                        )
                        .withFieldNames(AdFieldEnum.ID),
                new Api5Error(4001, Api5ErrorDetails.IN_STRUCTURE_MUST_BE_ONE_OF_REQUIRED_FIELD,
                        capitalize(GetRequestMap.SELECTION_CRITERIA),
                        capitalize(AdsSelectionCriteriaMap.IDS) + ", " + capitalize(AdsSelectionCriteriaMap.ADGROUP_IDS)
                                + ", " + capitalize(AdsSelectionCriteriaMap.CAMPAIGN_IDS)));
    }
}
