package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.BsDeadDomainsHelper;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 11.11.15.
 * https://st.yandex-team.ru/TESTIRT-7704
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка зависимости состояния объявления от состояния кампании")
@Issue("https://st.yandex-team.ru/DIRECT-47391")
@RunWith(Parameterized.class)
public class StateDependentOnCampaignStatusTest {
    private static final String ALIVE_DOMAIN = "alivetestdomain.xx";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId;


    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        int shard =  api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(AdsLogins.CLIENT);
        BsDeadDomainsHelper.removeFromBsDeadDomains(shard, api.userSteps.getDirectJooqDbSteps(), ALIVE_DOMAIN);
    }

    @Before
    public void createObjects() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
        BannerFakeInfo bannerFakeInfo = new BannerFakeInfo();
        bannerFakeInfo.setBid(adId);
        bannerFakeInfo.setStatusShow(Status.YES);
        bannerFakeInfo.setHref(ALIVE_DOMAIN);
        bannerFakeInfo.setStatusActive(Status.YES);
        api.userSteps.bannersFakeSteps().updateBannerParams(bannerFakeInfo);
    }

    @Test
    public void archivedCampaign() {
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном состоянии", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.ARCHIVED)
                        .withStatusClarification(StatusClarification.ARCHIVED.getStatusClarification()).getBean())));
    }

    @Test
    public void suspendedCampaign() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.NO);
        api.userSteps.campaignFakeSteps().setStatusShow(campaignId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном состоянии", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.OFF)
                        .withStatusClarification(StatusClarification.CAMPAIGN_STOPPED_WITH_DOT.getStatusClarification()).getBean())));
    }

    @Test
    public void notActiveCampaign() {
        api.userSteps.campaignFakeSteps().setStatusActive(campaignId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном состоянии", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.OFF)
                        .withStatusClarification(StatusClarification.DRAFT.getStatusClarification()).getBean())));
    }

    @Test
    public void suspendedCampaignRequestWithState() {
        //DIRECT-49102
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.NO);
        api.userSteps.campaignFakeSteps().setStatusShow(campaignId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                        .withStates(AdStateSelectionEnum.OFF))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном состоянии", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.OFF)
                        .withStatusClarification(StatusClarification.CAMPAIGN_STOPPED_WITH_DOT
                                .getStatusClarification()).getBean())));
    }
}
