package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdStateSelectionEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by pavryabov on 20.04.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля State в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class StateTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameterized.Parameter(0)
    public String statusShow;

    @Parameterized.Parameter(1)
    public String statusActive;

    @Parameterized.Parameter(2)
    public AdStateSelectionEnum state;

    @Parameterized.Parameter(3)
    public BannerType type;

    @Parameterized.Parameter(4)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(5)
    public CampaignType campaignType;

    @Parameterized.Parameters(name = "statusShow = {0}, statusActive = {1}, expected State = {2}, adType = {3}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NO, Status.YES, AdStateSelectionEnum.SUSPENDED,
                        BannerType.TEXT, AdGroupType.BASE, CampaignType.TEXT},
                {Status.NO, Status.NO, AdStateSelectionEnum.SUSPENDED,
                        BannerType.TEXT, AdGroupType.BASE, CampaignType.TEXT},
                {Status.YES, Status.YES, AdStateSelectionEnum.ON,
                        BannerType.TEXT, AdGroupType.BASE, CampaignType.TEXT},
                {Status.YES, Status.NO, AdStateSelectionEnum.OFF,
                        BannerType.TEXT, AdGroupType.BASE, CampaignType.TEXT},

                {Status.NO, Status.YES, AdStateSelectionEnum.SUSPENDED,
                        BannerType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT},
                {Status.NO, Status.NO, AdStateSelectionEnum.SUSPENDED,
                        BannerType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT},
                {Status.YES, Status.YES, AdStateSelectionEnum.ON,
                        BannerType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT},
                {Status.YES, Status.NO, AdStateSelectionEnum.OFF,
                        BannerType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT},

                {Status.NO, Status.YES, AdStateSelectionEnum.SUSPENDED,
                        BannerType.DYNAMIC, AdGroupType.DYNAMIC, CampaignType.DYNAMIC},
                {Status.NO, Status.NO, AdStateSelectionEnum.SUSPENDED,
                        BannerType.DYNAMIC, AdGroupType.DYNAMIC, CampaignType.DYNAMIC},
                {Status.YES, Status.YES, AdStateSelectionEnum.ON,
                        BannerType.DYNAMIC, AdGroupType.DYNAMIC, CampaignType.DYNAMIC},
                {Status.YES, Status.NO, AdStateSelectionEnum.OFF,
                        BannerType.DYNAMIC, AdGroupType.DYNAMIC, CampaignType.DYNAMIC},


        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
    }

    @Before
    public void createObjects() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        api.userSteps.campaignFakeSteps().setStatusActive(campaignId, Status.YES);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, type);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, statusShow);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, statusActive);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннеру установился правильный StatusShow",
                bannerFakeInfo.getStatusShow(), equalTo(statusShow));
        assumeThat("баннеру установился правильный StatusActive",
                bannerFakeInfo.getStatusActive(), equalTo(statusActive));
    }

    @Test
    public void getAd() {
        //DIRECT-41277
        //DIRECT-41195
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId).withStates(state))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        assertThat("Вернулся правильный State", getResponse.getAds(), beanEquivalent(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.fromValue(state.value())).getBean())));
    }
}
