package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса ACCEPTED в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class StatusAcceptedTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public BannerType type;

    @Parameterized.Parameter(2)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(3)
    public CampaignType campaignType;

    @Parameterized.Parameters(name = "statusModerate = {0}, type = {1}, statusPostModerate = Yes")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.YES, BannerType.TEXT, AdGroupType.BASE, CampaignType.TEXT},
                {Status.YES, BannerType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, CampaignType.MOBILE_CONTENT},
                {Status.YES, BannerType.DYNAMIC, AdGroupType.DYNAMIC, CampaignType.DYNAMIC}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
    }

    @Before
    public void createObject() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, type);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, statusModerate);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.YES.toString());
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннеру установился правильный StatusModerate",
                bannerFakeInfo.getStatusModerate(), equalTo(statusModerate));
        assumeThat("баннеру установился правильный StatusPoseModerate",
                bannerFakeInfo.getStatusPostModerate(), equalTo(Status.YES.toString()));
    }

    @Test
    public void getAcceptedAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId).withStatuses(AdStatusSelectionEnum.ACCEPTED))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS));
        assertThat("вернулся правильный Status", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).withStatus(StatusEnum.ACCEPTED).getBean())));
    }
}
