package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.BsDeadDomainsHelper;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.06.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(ApiFeatures.BUG)
@Description("Проверка значения поля StatusClarification в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class StatusClarificationTest {
    //DIRECT-42847
    private static final String ALIVE_DOMAIN = "alivetestdomain.xx";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        int shard =  api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(AdsLogins.CLIENT);
        BsDeadDomainsHelper.removeFromBsDeadDomains(shard, api.userSteps.getDirectJooqDbSteps(), ALIVE_DOMAIN);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withHref("http://" + ALIVE_DOMAIN))
                        .withAdGroupId(adGroupId));
    }

    @Test
    public void stateArchived() {
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
        api.userSteps.adsSteps().adsArchive(adId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).withState(StateEnum.ARCHIVED).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(StatusClarification.ARCHIVED.getStatusClarification()).getBean())));
    }

    @Test
    public void statusDraft() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).withStatus(StatusEnum.DRAFT).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(StatusClarification.DRAFT.getStatusClarification()).getBean())));
    }

    @Test
    public void statusModerationStateSuspended() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.SUSPENDED).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(StatusClarification.SUSPENDED.getStatusClarification()).getBean())));
    }

    @Test
    public void statusAcceptedStateOn() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.YES);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.ACCEPTED)
                        .withState(StateEnum.ON).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(StatusClarification.ON.getStatusClarification()).getBean())));
    }

    @Test
    public void statusModerationStateOn() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.YES);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.ON).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(
                                StatusClarification.PREVIOUS_VERSION_IS_RUNNING.getStatusClarification()).getBean())));
    }

    @Test
    public void statusModerationStateOff() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.MODERATION)
                        .withState(StateEnum.OFF).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(
                                StatusClarification.AWAITING_MODERATION.getStatusClarification()).getBean())));
    }

    @Test
    public void statusPreacceptedStateOff() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.PREACCEPTED)
                        .withState(StateEnum.OFF).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(
                                StatusClarification.PREVIOUSLY_ACCEPTED.getStatusClarification()).getBean())));
    }

    @Test
    public void statusAcceptedStateOff() {
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.ACCEPTED)
                        .withState(StateEnum.OFF).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(
                                StatusClarification.ACCEPTED.getStatusClarification()).getBean())));
    }

    @Test
    public void statusRejectedStateOff() {
        //DIRECT-42847
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusActive(adId, Status.NO);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATE, AdFieldEnum.STATUS_CLARIFICATION));
        assumeThat("объявление в правильном статусе и состоянии", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatus(StatusEnum.REJECTED)
                        .withState(StateEnum.OFF).getBean())));
        assertThat("вернулся правильный StatusClarification", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withStatusClarification(
                                StatusClarification.REJECTED.getStatusClarification()).getBean())));
    }
}
