package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса UNKNOWN в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class StatusUnknownTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public String statusPostModerate;

    @Parameterized.Parameters(name = "statusModerate = {0}, statusPostModerate = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.SENT, Status.SENT},
                {Status.SENT, Status.READY},
                {Status.SENT, Status.NEW},
                {Status.SENDING, Status.SENT},
                {Status.SENDING, Status.READY},
                {Status.SENDING, Status.NEW},
                {Status.READY, Status.SENT},
                {Status.READY, Status.READY},
                {Status.READY, Status.NEW},
                {Status.READY, Status.YES},
                {Status.YES, Status.NO},
                {Status.YES, Status.SENT},
                {Status.YES, Status.REJECTED},
                {Status.YES, Status.READY},
                {Status.YES, Status.NEW}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, statusModerate);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(adId, statusPostModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннеру установился правильный StatusModerate",
                bannerFakeInfo.getStatusModerate(), equalTo(statusModerate));
        assumeThat("баннеру установился правильный StatusPoseModerate",
                bannerFakeInfo.getStatusPostModerate(), equalTo(statusPostModerate));
    }

    @Test
    public void getUnknownAd() {
        //DIRECT-41195
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS));
        assertThat("вернулся правильный Status", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).withStatus(StatusEnum.UNKNOWN).getBean())));
    }
}
