package ru.yandex.autotests.direct.api.ads.get;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextImageAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации по Types")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@Tag(TagDictionary.TRUNK)
public class TypesTest {

    private static String CLIENT = AdsLogins.CLIENT42;
    private static Integer IMAGE_AD_JPG_728X90_IMAGE = 3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long mobileAppAdGroupId;
    private static Long mobileAppAdId;

    private static Long dynamicTextAdGroupId;
    private static Long dynamicTextAdId;

    private static Long dynamicTextFeedAdGroupId;
    private static Long dynamicTextFeedAdId;

    private static Long textAdId;
    private static Long mobileAdId;
    private static Long cpcVideoAdId;

    private static Long textImageAdId;
    private static Long mobileAppImageAdId;
    private static Long mobileAppCpcVideoAdId;

    private static String adImageHash;

    @BeforeClass
    public static void initTest() {
        api.as(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        textAdId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        mobileAdId = api.userSteps.adsSteps().addDefaultMobileAd(adGroupId);

        Long clientId = Long.valueOf(User.get(CLIENT).getClientID());

        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileAppAdGroupId);

        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        dynamicTextAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);

        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(CLIENT).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
        dynamicTextFeedAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextFeedAdGroupId);

        Long cpcVideoCreativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(clientId);
        cpcVideoAdId = api.userSteps.adsSteps().addDefaultCpcVideoAdBuilderAd(adGroupId, cpcVideoCreativeId);

        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(IMAGE_AD_JPG_728X90_IMAGE);
        textImageAdId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);
        mobileAppImageAdId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(mobileAppAdGroupId, adImageHash);
        mobileAppCpcVideoAdId = api.userSteps.adsSteps()
                .addDefaultMobileAppCpcVideoAdBuilderAd(mobileAppAdGroupId, cpcVideoCreativeId);
    }

    @Test
    public void getTypeOfTextAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(textAdId).withTypes(AdTypeEnum.TEXT_AD))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(textAdId).withType(AdTypeEnum.TEXT_AD).getBean())));
    }

    @Test
    public void getTypeOfMobileAd() {
        //DIRECT-43180
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(mobileAdId).withTypes(AdTypeEnum.TEXT_AD))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(mobileAdId).withType(AdTypeEnum.TEXT_AD).getBean())));
    }

    @Test
    public void getTypeOfCpcVideoAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(cpcVideoAdId).withTypes(AdTypeEnum.CPC_VIDEO_AD))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(cpcVideoAdId).withType(AdTypeEnum.CPC_VIDEO_AD).getBean())));
    }

    @Test
    @Description("Получить объявление с рекламой мобильных приложений по его типу")
    public void getMobileAppAdByType() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withAdGroupIds(mobileAppAdGroupId)
                        .withTypes(AdTypeEnum.MOBILE_APP_AD)));
        assertThat("вернулось mobile_app объявление", response.getAds(), beanDiffer(Arrays.asList(
                new AdGetItemMap()
                        .withId(mobileAppAdId)
                        .withType(AdTypeEnum.MOBILE_APP_AD).getBean())));
    }

    @Test
    @Description("Получить видеообъявление с рекламой мобильных приложений по его типу")
    public void getMobileAppCpcVideoAdByType() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withAdGroupIds(mobileAppAdGroupId)
                        .withTypes(AdTypeEnum.CPC_VIDEO_AD)));
        assertThat("вернулось видеообъявление РМП", response.getAds(), beanDiffer(Arrays.asList(
                new AdGetItemMap()
                        .withId(mobileAppCpcVideoAdId)
                        .withType(AdTypeEnum.CPC_VIDEO_AD).getBean())));
    }

    @Test
    @Description("Получить динамическое текстовое объявление по его типу")
    public void getDynamicTextAdsByType() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withAdGroupIds(dynamicTextAdGroupId)
                        .withTypes(AdTypeEnum.DYNAMIC_TEXT_AD)));
        assertThat("вернулось правильное объявление", response.getAds(), beanDiffer(Arrays.asList(
                new AdGetItemMap().withId(dynamicTextAdId).withType(AdTypeEnum.DYNAMIC_TEXT_AD).getBean())));
    }

    @Test
    @Description("Получить динамическое текстовое объявление из группы с фидом по его типу")
    public void getDynamicTextFeedAdsByType() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withAdGroupIds(dynamicTextFeedAdGroupId)
                        .withTypes(AdTypeEnum.DYNAMIC_TEXT_AD)));
        assertThat("вернулось правильное объявление", response.getAds(), beanDiffer(Arrays.asList(
                new AdGetItemMap().withId(dynamicTextFeedAdId).withType(AdTypeEnum.DYNAMIC_TEXT_AD).getBean())));
    }

    @Test
    public void getImageAdByType() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(textImageAdId, mobileAppImageAdId)
                        .withTypes(AdTypeEnum.IMAGE_AD)));
        assertThat("вернулось два объявления", response.getAds(), beanDiffer(Arrays.asList(
                new AdGetItemMap().withId(textImageAdId).withType(AdTypeEnum.IMAGE_AD).getBean(),
                new AdGetItemMap().withId(mobileAppImageAdId).withType(AdTypeEnum.IMAGE_AD).getBean()
        )));
    }

    @Test
    @Description("Получить хеш картинки для текстового и графического объявлений в рамках одной кампании")
    public void getAdImageHashFromTextAdAndImageAdInSameRequest() {
        //DIRECT-62752
        String wideAdImageHash = api.userSteps.imagesStepsV5().addDefaultWideAdImage();
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAdWithAdImageHash(adGroupId, AdGroupType.BASE, BannerType.TEXT, wideAdImageHash);
        api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_HASH)
                .withTextImageAdFieldNames(TextImageAdFieldEnum.AD_IMAGE_HASH)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withCampaignIds(campaignId)));

        List<AdGetItem> ads = response.getAds();

        List<String> adImageHashes = Arrays.asList(
                ads.get(0).getTextAd().getAdImageHash().getValue(),
                ads.get(1).getTextImageAd().getAdImageHash());

        assertThat("вернулось два объявления разных типов TextAd и ImageAd с привязанными изображениями", adImageHashes,
                beanDiffer(Arrays.asList(wideAdImageHash, adImageHash)));
    }

}
