package ru.yandex.autotests.direct.api.ads.get.cpcvideoadbuilderad;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static ru.yandex.autotests.direct.db.steps.PerfCreativesSteps.DEFAULT_LIVE_PREVIEW_URL;
import static ru.yandex.autotests.direct.db.steps.PerfCreativesSteps.DEFAULT_PREVIEW_URL;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-82646
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка выборки кликовых видеообъявлений")
@Issue("https://st.yandex-team.ru/DIRECT-82646")
public class GetCpcVideoAdBuilderAdTest {
    private static String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long adGroupId;
    private static Long campaignId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        DirectJooqDbSteps jooqDbSteps =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);

        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(clientId);

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdAddMap()
                                .withHref(TextAdAddMap.DEFAULT_HREF)
                                .withCreative(creativeId)
                        )
                        .withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdByAdId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withFieldNames(AdFieldEnum.ID)
                        .withCpcAdVideoAdBuilderAdFieldNames(CpcVideoAdBuilderAdFieldEnum.CREATIVE,
                                CpcVideoAdBuilderAdFieldEnum.HREF)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(singletonList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdGetMap()
                                        .withHref(TextAdBuilderAdAddMap.DEFAULT_HREF)
                                        .withCreative(new AdBuilderAdGetItemMap()
                                                .withThumbnailUrl(DEFAULT_PREVIEW_URL)
                                                .withPreviewUrl(DEFAULT_LIVE_PREVIEW_URL)
                                                .withCreativeId(creativeId)))
                                .getBean())));
    }

    @Test
    public void getAdByAdGroupId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withAdGroupIds(adGroupId)
                ).withCpcAdVideoAdBuilderAdFieldNames(CpcVideoAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpcVideoAdBuilderAd(
                                new CpcVideoAdBuilderAdGetMap().withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withCreativeId(creativeId)
                                                .withThumbnailUrl(DEFAULT_PREVIEW_URL)
                                                .withPreviewUrl(DEFAULT_LIVE_PREVIEW_URL)
                                ))
                        .getBean())));
    }

    @Test
    public void getAdByCampaignId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withCampaignIds(campaignId)
                ).withCpcAdVideoAdBuilderAdFieldNames(CpcVideoAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpcVideoAdBuilderAd(
                                new CpcVideoAdBuilderAdGetMap().withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withCreativeId(creativeId)
                                                .withThumbnailUrl(DEFAULT_PREVIEW_URL)
                                                .withPreviewUrl(DEFAULT_LIVE_PREVIEW_URL)
                                ))
                        .getBean())));
    }

    /**
     * При запросе типа MOBILE_APP_AD не возвращается cpc_video баннер из ТГО
     */
    @Test
    public void getByMobileAppAdType_NothingReturn() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap()
                                .withIds(adId)
                                .withTypes(AdTypeEnum.MOBILE_APP_AD)
                ).withFieldNames(AdFieldEnum.ID)
        );

        Assert.assertThat("cpc_video баннер не вернулся", getResponse.getAds(), beanDifferV5(emptyList()));
    }

    /**
     * При запросе типа CPC_VIDEO_AD возвращается cpc_video баннер из ТГО
     */
    @Test
    public void getByCpcVideoAdType() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap()
                                .withIds(adId)
                                .withTypes(AdTypeEnum.CPC_VIDEO_AD)
                ).withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId).getBean())));
    }
}
