package ru.yandex.autotests.direct.api.ads.get.cpmbanneradbuilderad;

import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.PixelProvider;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TrackingPixelGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка получения креативов и пикселей")
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class GetCpmBannerAdCreativesAndPixelsTest {

    private static String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
    }

    @Test
    public void getCanvasCreative() {
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        Long adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withCpmBannerAdBuilderAd(
                        new CpmBannerAdBuilderAdAddMap().defaultCpmBannerAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Collections.singletonList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdGetMap().withCreative(
                                                new AdBuilderAdGetItemMap()
                                                        .withCreativeId(creativeId)
                                                        .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                        .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        ))
                                .getBean())));
    }

    @Test
    public void getHtml5Creative() {
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultHtml5CreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        Long adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withCpmBannerAdBuilderAd(
                        new CpmBannerAdBuilderAdAddMap().defaultCpmBannerAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Collections.singletonList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdGetMap().withCreative(
                                                new AdBuilderAdGetItemMap()
                                                        .withCreativeId(creativeId)
                                                        .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                        .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        ))
                                .getBean())));
    }

    @Test
    public void getTrackingPixels() {
        PixelProvider pixel = PixelProvider.YANDEXAUDIENCE;
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        Long adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withCpmBannerAdBuilderAd(
                        new CpmBannerAdBuilderAdAddMap()
                                .defaultCpmBannerAdBuilderAd(creativeId)
                                .withTrackingPixels(Collections.singletonList(pixel.testUrl()))
                ).withAdGroupId(adGroupId)
        );
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.TRACKING_PIXELS)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Collections.singletonList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdGetMap()
                                                .withTrackingPixels(new TrackingPixelGetItemMap()
                                                        .withTrackingPixel(pixel.testUrl())
                                                        .withProvider(pixel.providerName())))
                                .getBean())));
    }

    @Test
    public void getTrackingPixelsWithUnknownProvider() {
        String unknownPixel = "someUrl";
        Long creativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        Long adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withCpmBannerAdBuilderAd(
                        new CpmBannerAdBuilderAdAddMap()
                                .defaultCpmBannerAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
        dbSteps.pixelsSteps().createAndSaveNewPixelForBanner(adId, unknownPixel);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.TRACKING_PIXELS)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Collections.singletonList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdGetMap()
                                                .withTrackingPixels(new TrackingPixelGetItemMap()
                                                        .withTrackingPixel(unknownPixel)
                                                        .withProvider(TrackingPixelGetItemMap.UNKNOWN_PROVIDER)))
                                .getBean())));
    }
}
