package ru.yandex.autotests.direct.api.ads.get.cpmbanneradbuilderad;

import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.PixelProvider;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TrackingPixelGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка работы поля CpmBannerAdBuilderAdFieldNames")
public class GetCpmBannerAdFieldNamesTest {

    private static final String CLIENT = AdsLogins.CLIENT43;
    private static final PixelProvider PIXEL = PixelProvider.YANDEXAUDIENCE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        DirectJooqDbSteps jooqDbSteps =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withCpmBannerAdBuilderAd(
                        new CpmBannerAdBuilderAdAddMap()
                                .defaultCpmBannerAdBuilderAd(creativeId)
                                .withTrackingPixels(Collections.singletonList(PIXEL.testUrl()))
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdWithAllCpmBannerAdBuilderAdFieldNames() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdGetMap()
                                .withHref(CpmBannerAdBuilderAdAddMap.DEFAULT_HREF)
                                .withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withCreativeId(creativeId))
                                .withTrackingPixels(new TrackingPixelGetItemMap()
                                        .withTrackingPixel(PIXEL.testUrl())
                                        .withProvider(PIXEL.providerName()))
                                .withTurboPageId(null)
                                .withTurboPageModeration(null)
                        ).getBean())));
    }

    @Test
    public void getAdWithAdCreativeIdOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withCpmBannerAdBuilderAdFieldNames(
                        CpmBannerAdBuilderAdFieldEnum.CREATIVE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdGetMap()
                                .withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withCreativeId(creativeId)
                                )
                        ).getBean())));
    }

    @Test
    public void getAdWithHrefOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withCpmBannerAdBuilderAdFieldNames(
                        CpmBannerAdBuilderAdFieldEnum.HREF
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdGetMap()
                                .withHref(CpmBannerAdBuilderAdAddMap.DEFAULT_HREF)
                        ).getBean())));
    }

    @Test
    public void getAdWithTrackingPixelsOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withCpmBannerAdBuilderAdFieldNames(CpmBannerAdBuilderAdFieldEnum.TRACKING_PIXELS));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdGetMap()
                                .withTrackingPixels(new TrackingPixelGetItemMap()
                                        .withTrackingPixel(PIXEL.testUrl())
                                        .withProvider(PIXEL.providerName()))
                        ).getBean())));
    }
}
