package ru.yandex.autotests.direct.api.ads.get.cpmbanneradbuilderad;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(AdsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
public class GetCpmBannerAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long campaignId;
    private static Long cpmBannerAdGroupId;
    private static Long cpmVideoAdGroupId;
    private static Long cpmBannerAdId;
    private static Long cpmVideoAdId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long creativeId = dbSteps.perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        cpmVideoAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmVideoAdId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(cpmVideoAdGroupId, creativeId);
        dbSteps.adGroupsSteps().setType(cpmVideoAdGroupId, PhrasesAdgroupType.cpm_video);

        cpmBannerAdGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        cpmBannerAdId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(cpmBannerAdGroupId, creativeId);
    }

    @Test
    public void getCpmBannerAdById() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withIds(cpmBannerAdId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объект получен", response.getAds(),
                beanDiffer(singletonList(new AdGetItemMap().withId(cpmBannerAdId).getBean())));
    }

    @Test
    public void getCpmVideoAdById() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withIds(cpmVideoAdId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления группы типа cpm_video получены", response.getAds(), hasSize(1));
    }

    @Test
    public void getCpmBannerAdByAdGroupId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withAdGroupIds(cpmBannerAdGroupId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объект получен", response.getAds(),
                beanDiffer(singletonList(new AdGetItemMap().withId(cpmBannerAdId).getBean())));
    }

    @Test
    public void getCpmVideoAdByAdGroupId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withAdGroupIds(cpmVideoAdGroupId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления группы типа cpm_video получены", response.getAds(), hasSize(1));
    }

    @Test
    public void getCpmBannerAdByCampaignId() {
        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withCampaignIds(campaignId)
                        )
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("объявления кампании типа cpm_banner получены", response.getAds(),
                containsInAnyOrder(new AdGetItemMap().withId(cpmBannerAdId).getBean(),
                        new AdGetItemMap().withId(cpmVideoAdId).getBean()));
    }
}
