package ru.yandex.autotests.direct.api.ads.get.dynamictextad;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка соответствия возвращаемых полей, указанным в DynamicDynamicTextAdFieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class DynamicTextAdFieldNamesTest {

    private static String client = AdsLogins.CLIENT19;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;
    static String adImageHash;
    static Long sitelinkSetId;
    static Long vCardId;
    static Long adExtensionId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addDefaultRegularAdImage();
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withDynamicTextAd(
                new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withAdImageHash(adImageHash)
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)
                        .withAdExtensionIds(adExtensionId))
                .withAdGroupId(adGroupId));
    }

    @Test
    public void getAdWithAllDynamicTextAdFieldNames() {
        //DIRECT-41119
        //DIRECT-42191
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.AD_IMAGE_HASH,
                        DynamicTextAdFieldEnum.SITELINK_SET_ID,
                        DynamicTextAdFieldEnum.TEXT,
                        DynamicTextAdFieldEnum.V_CARD_ID,
                        DynamicTextAdFieldEnum.AD_IMAGE_MODERATION,
                        DynamicTextAdFieldEnum.SITELINKS_MODERATION,
                        DynamicTextAdFieldEnum.V_CARD_MODERATION,
                        DynamicTextAdFieldEnum.AD_EXTENSIONS
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                                .withVCardId(vCardId)
                                .withAdImageHash(adImageHash)
                                .withSitelinkSetId(sitelinkSetId)
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.DRAFT)
                                                .withStatusClarification(
                                                        StatusClarification.DRAFT.getStatusClarification()))
                                .withSitelinksModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withAdImageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.AD_IMAGE_HASH
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withAdImageHash(adImageHash)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlySitelinksSetId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.SITELINK_SET_ID
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withSitelinkSetId(sitelinkSetId)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdExtensionIds() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.AD_EXTENSIONS
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyText() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.TEXT
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyVCardId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.V_CARD_ID
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withVCardId(vCardId)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdImageModeration() {
        //DIRECT-42334
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.AD_IMAGE_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withAdImageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlySitelinksModeration() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.SITELINKS_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withSitelinksModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyVCardModeration() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(
                        DynamicTextAdFieldEnum.V_CARD_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.DRAFT)
                                                .withStatusClarification(
                                                        StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }
}
