package ru.yandex.autotests.direct.api.ads.get.dynamictextad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 11.08.16.
 * https://st.yandex-team.ru/TESTIRT-10037
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка получения объявлений из ДО-групп (с фидом и по сайту)")
@Issue("https://st.yandex-team.ru/DIRECT-55149")
public class GetDynamicTextFeedAdByAdGroupIdTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long dynamicTextAdGroupId;
    private static Long dynamicTextFeedAdGroupId;
    private static Long dynamicTextAdId;
    private static Long dynamicTextFeedAdId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        dynamicTextFeedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(dynamicTextFeedAdGroupId, feedId);
        dynamicTextAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);
        dynamicTextFeedAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextFeedAdGroupId);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    public void getAdByDynamicTextAdGroupId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withAdGroupIds(dynamicTextAdGroupId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_GROUP_ID));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withAdGroupId(dynamicTextAdGroupId).withId(dynamicTextAdId).getBean())));
    }

    @Test
    public void getAdByDynamicTextFeedAdGroupId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withAdGroupIds(dynamicTextFeedAdGroupId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_GROUP_ID));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withAdGroupId(dynamicTextFeedAdGroupId).withId(dynamicTextFeedAdId).getBean())));
    }
}
