package ru.yandex.autotests.direct.api.ads.get.dynamictextad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 21.06.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса VCardModeration в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@RunWith(Parameterized.class)
public class VCardModerationStatusTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    Long adId;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public StatusEnum expectedStatus;

    @Parameterized.Parameter(2)
    public StatusClarification expectedStatusClarification;

    @Parameterized.Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NEW.toString(), StatusEnum.DRAFT, StatusClarification.DRAFT},
                {Status.SENT.toString(), StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.SENDING.toString(), StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.READY.toString(), StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.NO.toString(), StatusEnum.REJECTED, StatusClarification.CONTACT_INFO_REJECTED},
                {Status.YES.toString(), StatusEnum.ACCEPTED, StatusClarification.CONTACT_INFO_ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
    }

    @Before
    public void createObjects() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId.longValue());
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withDynamicTextAd(
                new DynamicTextAdAddMap().defaultDynamicTextAd().withVCardId(vCardId)).withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setPhoneflag(adId, statusModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("визитке установился правильный StatusModerate",
                bannerFakeInfo.getPhoneFlag(), equalTo(statusModerate));
    }

    @Test
    public void getAd() {
        //DIRECT-42945
        //DIRECT-42847
        //DIRECT-43128
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.fromValue(expectedStatus.value()))
                )
                .withFieldNames(AdFieldEnum.ID)
                .withDynamicTextAdFieldNames(DynamicTextAdFieldEnum.V_CARD_MODERATION));
        assertThat("вернулся правильный Status в VCardModeration", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withDynamicTextAd(new DynamicTextAdGetMap()
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(expectedStatus)
                                                .withStatusClarification(expectedStatusClarification.getStatusClarification())
                                )).getBean())));
    }
}
