package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.enums.AdActionObjectType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by alexteut on 07.09.16.
 * https://st.yandex-team.ru/TESTIRT-10149
 */

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка загрузки значений кнопок для объявления с рекламой мобильного приложения")
@Issue("https://st.yandex-team.ru/DIRECT-54926")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetMobileAppAdActionTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public AdActionObjectType appAdAction;

    @Parameterized.Parameters(name = "appAdAction = {0}")
    public static Iterable<Object[]> data() {
        return Stream.of(AdActionObjectType.values())
                .map(x -> new Object[]{x})
                .collect(Collectors.toList());
    }

    private static Long campaignId;
    private static Long adGroupId;

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
    }

    @Test
    @Description("Получить действие объявления с рекламой мобильного приложения")
    public void getAction() {
        AddResponse addResponse = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withAdGroupId(adGroupId)
                                .withMobileAppAd(new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAction(appAdAction.getMobileAppAdAction()))
                        ),
                ExpectedResult.success());
        long adId = addResponse.getAddResults().get(0).getId();
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.ACTION));

        assertThat("действие соответствует ожидаемому", getResponse.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withAction(appAdAction.getMobileAppAdAction())).getBean())));
    }
}
