package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdStatusSelectionEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка фильтрации по Status для объявлений с рекламой мобильных приложений")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
public class GetMobileAppAdByStatusTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long draftAd;
    private static long moderationAd;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);

        draftAd = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        moderationAd = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        api.userSteps.bannersFakeSteps().setStatusModerate(moderationAd, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusPostModerate(moderationAd, Status.NO);
    }

    @Test
    @Description("Сделать запрос на получение объявления-черновика, указав статус в запросе \"на модерации\"")
    public void getAdAndOtherStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(draftAd)
                        .withStatuses(AdStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

    @Test
    @Description("Сделать запрос на получение объявления-черновика, указав статус в запросе \"черновик\"")
    public void getAdAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(draftAd)
                        .withStatuses(AdStatusSelectionEnum.DRAFT, AdStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулось одно объявление", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(draftAd).getBean())));
    }

    @Test
    @Description("Сделать запрос на получение объявления-черновика и объявления на модерации," +
            " указав статус \"черновик\"")
    public void getTwoAdsAndStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(draftAd, moderationAd)
                        .withStatuses(AdStatusSelectionEnum.DRAFT))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулось одно объявление", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(draftAd).getBean())));
    }

    @Test
    @Description("Сделать запрос на получение объявления-черновика и объявления на модерации, " +
            "указав статусы \"черновик\" и \"на модерации\"")
    public void getTwoAdsAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(draftAd, moderationAd)
                        .withStatuses(AdStatusSelectionEnum.DRAFT, AdStatusSelectionEnum.MODERATION))
                .withFieldNames(AdFieldEnum.ID));
        assertThat("вернулось два объявления", getResponse.getAds(), beanDiffer(
                Arrays.asList(
                        (AdGetItem) new AdGetItemMap().withId(draftAd).getBean(),
                        (AdGetItem) new AdGetItemMap().withId(moderationAd).getBean())));
    }
}
