package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.AdgroupsMobileContentUtils;
import ru.yandex.autotests.directapi.darkside.model.MobileContentUtils;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdFeatureGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdFeatureItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка работоспособности поля MobileAppAdFieldNames в запросе на получение объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
@Tag(TagDictionary.TRUNK)
public class GetMobileAppAdFieldNamesTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    private static final MobileAppFeatureEnum EXPECTED_FEATURE = MobileAppAdAddMap.DEFAULT_FEATURES.get(0).getFeature();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adId;

    @BeforeClass
    public static void prepareData() {
        String clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);

        long mobileContentId = jooqDbSteps.mobileContentSteps()
                .saveMobileContent(MobileContentUtils.getDefaultMobileContent(clientId));
        AdgroupsMobileContentRecord adgroupsMobileContentRecord =
                AdgroupsMobileContentUtils.getDefaultAdgroupsMobileContent(adGroupId, mobileContentId);
        jooqDbSteps.mobileContentSteps().saveAdgroupsMobileContent(adgroupsMobileContentRecord);

        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withMobileAppAd(new MobileAppAdAddMap()
                        .defaultMobileAppAd()
                        .withFeatures(new MobileAppAdFeatureItemMap()
                                .withEnabled(YesNoEnum.YES)
                                .withFeature(EXPECTED_FEATURE))));
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Получить заголовок объявления с рекламой мобильного приложения")
    public void getTitle() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TITLE));

        assertThat("заголовок объявления соответствует ожидаемому", response.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withTitle(MobileAppAdAddMap.DEFAULT_TITLE)).getBean())));
    }

    @Test
    @Description("Получить текст объявления с рекламой мобильного приложения")
    public void getText() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TEXT));

        assertThat("текст объявления соответствует ожидаемому", response.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withText(MobileAppAdAddMap.DEFAULT_TEXT)).getBean())));
    }

    @Test
    @Description("Получить ссылку объявления с рекламой мобильного приложения")
    public void getTrackingUrl() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TRACKING_URL));

        assertThat("ссылка объявления соответствует ожидаемому", response.getAds(), beanDifferV5(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withTrackingUrl(MobileAppAdAddMap.DEFAULT_TRACKING_URL)).getBean())));
    }

    @Test
    @Description("Получить действие объявления с рекламой мобильного приложения")
    public void getAction() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.ACTION));

        assertThat("действие объявления соответствует ожидаемому", response.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withAction(MobileAppAdAddMap.DEFAULT_ACTION)).getBean())));
    }

    @Test
    @Description("Получить Features объявления с рекламой мобильного приложения")
    public void getFeatures() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.FEATURES));
        assumeThat("вернулось одно объявление", response.getAds(), hasSize(1));

        MatchVariation variation = new DefaultMatchVariation()
                .forFields("[0]/mobileAppAd/features").useMatcher(notNullValue());
        assertThat("Features объявления соответствует ожидаемому", response.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppAd(new MobileAppAdGetMap()
                                .withFeatures(new MobileAppAdFeatureGetItemMap())).getBean())).withVariation(variation));
    }

    @Test
    @Description("Получить текст и заголовок объявления в одном запросе")
    public void getTextAndTitle() {
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TEXT, MobileAppAdFieldEnum.TITLE));

        assertThat("текст и заголовок объявления соответствует ожидаемому", response.getAds(), beanDiffer(Arrays.asList(
                (AdGetItem) new AdGetItemMap().withId(adId).withMobileAppAd(new MobileAppAdGetMap()
                        .withTitle(MobileAppAdAddMap.DEFAULT_TITLE)
                        .withText(MobileAppAdAddMap.DEFAULT_TEXT)).getBean())));
    }
}
