package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка получения объявлений РМП от имени разных ролей")
@RunWith(Parameterized.class)
public class GetMobileAppAdRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String apiUserLogin;

    @Parameterized.Parameter(2)
    public String login;

    @Parameterized.Parameter(3)
    public String loginToCreateAd;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"Получение объявления от имени менеджера",
                        Logins.MANAGER_DEFAULT, AdsLogins.SERV_CLIENT, AdsLogins.MANAGER_DEFAULT},

                {"Получение объявления от имени вешальщика",
                        Logins.PLACER, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени саппорта",
                        Logins.SUPPORT, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени супера",
                        Logins.SUPER_LOGIN, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени медиапланера",
                        Logins.MEDIA, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени суперридера",
                        Logins.SUPER_READER, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени клиента для самого себя",
                        AdsLogins.CLIENT, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени представителя клиента для клиента",
                        AdsLogins.CLIENT_REP, AdsLogins.CLIENT, AdsLogins.CLIENT},

                {"Получение объявления от имени агенства для субклиента",
                        AdsLogins.AGENCY, AdsLogins.SUBCLIENT, AdsLogins.AGENCY},

                {"Получение объявления от имени представителя агенства для субклиента",
                        AdsLogins.AGENCY_REP, AdsLogins.SUBCLIENT, AdsLogins.AGENCY_REP},

                {"Получение объявления от имени субклиента",
                        AdsLogins.SUBCLIENT, AdsLogins.SUBCLIENT, AdsLogins.AGENCY}
        });
    }

    private long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(apiUserLogin);

        api.as(loginToCreateAd);
        Long campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(login);
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID, login);
        adID = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupID, login);
    }

    @Test
    public void requestUsingLogin() {
        api.as(apiUserLogin);
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withFieldNames(AdFieldEnum.ID)
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adID)),
                login);
        assertThat("вернулось одно объявление", response.getAds(), hasSize(1));
    }
}
