package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by proxeter on 01.03.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Description("Проверка получения изображения у РМП")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@RunWith(Parameterized.class)
@Feature(AdsFeatures.GET)
public class GetMobileAppAdWithAdImageModerationStatusTest {

    private static final String LOGIN = AdsLogins.CLIENT25;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;
    private Long adGroupId;
    private Long campaignId;

    private String associatedHash;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public StatusEnum expectedStatus;

    @Parameterized.Parameter(2)
    public StatusClarification expectedStatusClarification;

    @Parameterized.Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NEW.toString(), StatusEnum.DRAFT, StatusClarification.DRAFT},
                {Status.SENT.toString(), StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.SENDING.toString(), StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.READY.toString(), StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.NO.toString(), StatusEnum.REJECTED, StatusClarification.IMAGE_REJECTED},
                {Status.YES.toString(), StatusEnum.ACCEPTED, StatusClarification.IMAGE_ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    public void before() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.WIDE, 1);
        associatedHash = hashes[0];

        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAdImageHash(associatedHash)
                        )
        );

        api.userSteps.bannersFakeSteps().setImageStatusModerate(adId, statusModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("картинке установился правильный StatusModerate",
                bannerFakeInfo.getImageStatusModerate(), equalTo(statusModerate));
    }

    @Test
    public void getMobileAppAdWithAdImage() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withIds(adId)
                                        .withAdImageModerationStatuses(ExtensionStatusSelectionEnum.fromValue(expectedStatus.value()))
                        )
                        .withFieldNames(AdFieldEnum.ID)
                        .withMobileAppAdFieldNames(MobileAppAdFieldEnum.AD_IMAGE_MODERATION)
        );

        assertThat(
                "получены верные статусы привязки изображения",
                getResponse.getAds(),
                beanDifferV5(
                        Arrays.asList(
                                (AdGetItem) new AdGetItemMap()
                                        .withId(adId)
                                        .withMobileAppAd(
                                                new MobileAppAdGetMap()
                                                        .withAdImageModeration(
                                                                new ExtensionModerationMap()
                                                                        .withStatus(expectedStatus)
                                                                        .withStatusClarification(expectedStatusClarification.getStatusClarification())
                                                        )
                                        )
                                        .getBean())
                )
        );
    }

}
