package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.aqua.annotations.project.Feature;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 01.03.16.
 *
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Description("Проверка получения несуществующего изображения у РМП")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
@Feature(AdsFeatures.GET)
public class GetMobileAppAdWithInvalidAdImageTest {

    private static final String LOGIN = AdsLogins.CLIENT27;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;
    private Long adGroupId;
    private Long campaignId;

    private String associatedHash;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        String[] hashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.WIDE, 1);
        associatedHash = hashes[0];

        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withAdGroupId(adGroupId)
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withAdImageHash(associatedHash)
                        )
        );
    }

    @Test
    public void getMobileAppAdWithInvalidAdImage() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap()
                                        .withIds(adId)
                                        .withAdImageHashes(RandomStringUtils.randomAlphabetic(8))
                        )
                        .withFieldNames(AdFieldEnum.ID)
                        .withMobileAppAdFieldNames(MobileAppAdFieldEnum.AD_IMAGE_HASH)
        );

        assertThat("картинка не найдена", getResponse.getAds(), hasSize(0));
    }

}
