package ru.yandex.autotests.direct.api.ads.get.mobileappad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 14.09.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля AdCategories в ответе Ads.get для объявления с РМП")
@RunWith(Parameterized.class)
public class MobileAppAdAdCategoriesTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;


    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public ModerationFlag moderationFlag;

    @Parameterized.Parameter(1)
    public AdCategoryEnum expectedAdCategories;

    @Parameterized.Parameters(name = "moderationFlag = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {ModerationFlag.ABORTION, AdCategoryEnum.ABORTION},

                //DIRECT-49948
                {ModerationFlag.MEDICINE, AdCategoryEnum.MEDICINE},
                {ModerationFlag.MED_SERVICES, AdCategoryEnum.MEDICINE},
                {ModerationFlag.MED_EQUIPMENT, AdCategoryEnum.MEDICINE},
                {ModerationFlag.PHARMACY, AdCategoryEnum.MEDICINE},

                {ModerationFlag.ALCOHOL, AdCategoryEnum.ALCOHOL},
                {ModerationFlag.TOBACCO, AdCategoryEnum.TOBACCO},
                {ModerationFlag.DIETARY_SUPPL, AdCategoryEnum.DIETARY_SUPPLEMENTS},
                {ModerationFlag.PSEUDO_WEAPON, AdCategoryEnum.PSEUDO_WEAPON},
                {ModerationFlag.TRAGIC, null},
                {ModerationFlag.ADULT, null},
                {ModerationFlag.BABY_FOOD_0, AdCategoryEnum.BABY_FOOD},
                {ModerationFlag.AGE_0, null},
                {ModerationFlag.FOREX, null},
                {ModerationFlag.PROJECT_DECLARATION, AdCategoryEnum.PROJECT_DECLARATION}
        };
        return Arrays.asList(data);
    }

    private long adId;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);

        adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);
        api.userSteps.bannersFakeSteps().setBannerFlags(adId, moderationFlag);
    }

    @Test
    public void getAdCategories() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_CATEGORIES));
        assertThat("вернулось объявление с правильным занчением AdCategories", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withAdCategories(expectedAdCategories).getBean())));
    }
}
