package ru.yandex.autotests.direct.api.ads.get.mobileappadbuilderad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка работы поля MobileAppAdBuilderAdFieldNames")
public class GetMobileAppAdBuilderAdFieldNamesTest {

    private static String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withMobileAppAdBuilderAd(
                        new MobileAppAdBuilderAdAddMap().defaultMobileAppAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdWithAllMobileAppAdBuilderAdFieldNames() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdBuilderAdFieldNames(MobileAppAdBuilderAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppAdBuilderAd(new MobileAppAdBuilderAdGetMap()
                                .withTrackingUrl(MobileAppAdBuilderAdAddMap.DEFAULT_TRACKING_URL)
                                .withCreative(new AdBuilderAdGetItemMap()
                                        .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        .withCreativeId(creativeId))
                        ).getBean())));
    }

    @Test
    public void getAdWithAdCreativeIdOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdBuilderAdFieldNames(
                        MobileAppAdBuilderAdFieldEnum.CREATIVE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppAdBuilderAd(new MobileAppAdBuilderAdGetMap()
                                .withCreative(new AdBuilderAdGetItemMap()
                                        .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        .withCreativeId(creativeId))
                        ).getBean())));
    }

    @Test
    public void getAdWithUrlOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppAdBuilderAdFieldNames(
                        MobileAppAdBuilderAdFieldEnum.TRACKING_URL
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppAdBuilderAd(new MobileAppAdBuilderAdGetMap()
                                .withTrackingUrl(MobileAppAdBuilderAdAddMap.DEFAULT_TRACKING_URL)
                        ).getBean())));
    }

}
