package ru.yandex.autotests.direct.api.ads.get.mobileappadbuilderad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка полей Status и StatusClarification у мобильных графических объявлений")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
@RunWith(Parameterized.class)
public class GetMobileAppBuilderAdStatusAndStatusClarificationTest {
    private static String CLIENT = AdsLogins.CLIENT43;
    private static Long creativeId;
    private static Long adId;
    private static Long adGroupId;
    private static Long campaignId;
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter(0)
    public BannersStatusmoderate bannerStatusModerate;

    @Parameterized.Parameter(1)
    public BannersStatuspostmoderate bannerStatusPostModerate;

    @Parameterized.Parameter(2)
    public BannersPerformanceStatusmoderate bannersPerfarmanceStatusModerate;

    @Parameterized.Parameter(3)
    public StatusEnum expectedStatus;

    @Parameterized.Parameter(4)
    public StatusClarification expectedStatusClarification;

    @Parameterized.Parameters(name = "bannerStatusModerate = {0}, bannerStatusPostModerate = {1}, bannersPerformanceStatusmoderate = {2}, expectedStatus = {3}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BannersStatusmoderate.New, BannersStatuspostmoderate.New, BannersPerformanceStatusmoderate.New, StatusEnum.DRAFT, StatusClarification.DRAFT},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.Yes, BannersPerformanceStatusmoderate.Yes, StatusEnum.ACCEPTED, StatusClarification.ACCEPTED},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.No, StatusEnum.REJECTED, StatusClarification.REJECTED},

                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sent, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sending, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Ready, StatusEnum.REJECTED, StatusClarification.REJECTED},

                {BannersStatusmoderate.Ready, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sent, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sending, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},

                {BannersStatusmoderate.Ready, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sending, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sent, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sending, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sending, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sending, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Sending, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},

                {BannersStatusmoderate.Ready, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sent, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Sending, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.No, BannersPerformanceStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);

    }

    @Before
    public void prepareData() {
        jooqDbSteps.bannersSteps().updateBanners(new BannersRecord()
                .setBid(adId)
                .setStatusmoderate(bannerStatusModerate)
                .setStatuspostmoderate(bannerStatusPostModerate));
        BannersRecord bannersRecord = jooqDbSteps.bannersSteps().getBanner(adId);
        assumeThat("установился правильный statusModerate у объявления", bannersRecord.getStatusmoderate(), equalTo(bannerStatusModerate));
        assumeThat("установился правильный statusPostModerate у объявления", bannersRecord.getStatuspostmoderate(), equalTo(bannerStatusPostModerate));
        jooqDbSteps.bannersPerformanceSteps().setCreativeStatusModerate(campaignId, adGroupId, adId, bannersPerfarmanceStatusModerate);
        assumeThat("установился правильный statusModerate у креатива",
                jooqDbSteps.bannersPerformanceSteps().getBannersPerformance(adId, creativeId).getStatusmoderate(),
                equalTo(bannersPerfarmanceStatusModerate));
    }

    @Test
    public void getAdAndCheckStatusAndStatusClarification() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATUS_CLARIFICATION)
        );
        assertThat("вернулись правильные Status и StatusClarification объявления", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withStatus(expectedStatus)
                        .withStatusClarification(expectedStatusClarification.getStatusClarification()).getBean())));
    }

    @Test
    public void getAdByStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId).withStatuses(expectedStatus.toString())
                ).withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATUS_CLARIFICATION)
        );
        assertThat("успешно получили объявление по статусу модерации",
                getResponse.getAds(),
                beanEquivalentV5(
                        Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).getBean())
                )
        );
    }

}
