package ru.yandex.autotests.direct.api.ads.get.mobileappcpcvideoadbuilderad;

import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AdSubtypeEnum;
import com.yandex.direct.api.v5.ads.AdTypeEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppCpcVideoAdBuilderAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppCpcVideoAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.direct.db.steps.PerfCreativesSteps.DEFAULT_LIVE_PREVIEW_URL;
import static ru.yandex.autotests.direct.db.steps.PerfCreativesSteps.DEFAULT_PREVIEW_URL;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка работы поля MobileAppCpcAdVideoAdBuilderAdFieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
public class MobileAppCpcVideoAdBuilderAdFieldNamesTest {
    private static final String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long creativeId;
    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        long clientId = Long.parseLong(User.get(CLIENT).getClientID());

        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);

        DirectJooqDbSteps jooqDbSteps =
                api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCpcVideoCreative(clientId);

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withMobileAppCpcVideoAdBuilderAd(
                        new MobileAppCpcVideoAdBuilderAdAddMap().defaultMobileAppCpcVideoAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdWithAllMobileAppCpcVideoAdFieldNames() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.TYPE, AdFieldEnum.SUBTYPE)
                .withMobileAppCpcAdVideoAdBuilderAdFieldNames(MobileAppCpcVideoAdBuilderAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withType(AdTypeEnum.CPC_VIDEO_AD)
                        .withSubtype(AdSubtypeEnum.MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD)
                        .withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdGetMap()
                                .withTrackingUrl(MobileAppCpcVideoAdBuilderAdAddMap.DEFAULT_TRACKING_URL)
                                .withCreative(new AdBuilderAdGetItemMap()
                                        .withCreativeId(creativeId)
                                        .withThumbnailUrl(DEFAULT_PREVIEW_URL)
                                        .withPreviewUrl(DEFAULT_LIVE_PREVIEW_URL))
                        ).getBean())));
    }

    @Test
    public void getAdWithTrackingUrlOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppCpcAdVideoAdBuilderAdFieldNames(
                        MobileAppCpcVideoAdBuilderAdFieldEnum.TRACKING_URL
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdGetMap()
                                .withTrackingUrl(MobileAppCpcVideoAdBuilderAdAddMap.DEFAULT_TRACKING_URL)
                        ).getBean())));
    }

    @Test
    public void getAdWithCreativeOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withMobileAppCpcAdVideoAdBuilderAdFieldNames(
                        MobileAppCpcVideoAdBuilderAdFieldEnum.CREATIVE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withMobileAppCpcVideoAdBuilderAd(new MobileAppCpcVideoAdBuilderAdGetMap()
                                .withCreative(new AdBuilderAdGetItemMap()
                                        .withCreativeId(creativeId)
                                        .withThumbnailUrl(DEFAULT_PREVIEW_URL)
                                        .withPreviewUrl(DEFAULT_LIVE_PREVIEW_URL))
                        ).getBean())));
    }

}
