package ru.yandex.autotests.direct.api.ads.get.mobileappimagead;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.ImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 08.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка полей Status и StatusClarification у графических объявлений РМП")
@Issue("https://st.yandex-team.ru/DIRECT-54753")
@RunWith(Parameterized.class)
public class GetMobileAppImageAdStatusAndStatusClarificationTest {
    private static String client = AdsLogins.CLIENT42;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long adGroupId;
    private static Long campaignId;
    private static String adImageHash;
    private static DirectJooqDbSteps jooqDbSteps;

    @Parameterized.Parameter(0)
    public BannersStatusmoderate bannerStatusModerate;

    @Parameterized.Parameter(1)
    public BannersStatuspostmoderate bannerStatusPostModerate;

    @Parameterized.Parameter(2)
    public ImagesStatusmoderate imageAdStatusModerate;

    @Parameterized.Parameter(3)
    public StatusEnum expectedStatus;

    @Parameterized.Parameter(4)
    public StatusClarification expectedStatusClarification;

    @Parameterized.Parameters(name = "bannerStatusModerate = {0}, bannerStatusPostModerate = {1}, imageAdStatusModerate = {2}, expectedStatus = {3}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BannersStatusmoderate.New, BannersStatuspostmoderate.New, ImagesStatusmoderate.New, StatusEnum.DRAFT, StatusClarification.DRAFT},
                {BannersStatusmoderate.Ready, BannersStatuspostmoderate.Ready, ImagesStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, ImagesStatusmoderate.Sending, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.Yes, ImagesStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.AWAITING_MODERATION},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.Yes, ImagesStatusmoderate.Yes, StatusEnum.ACCEPTED, StatusClarification.ACCEPTED},
                {BannersStatusmoderate.Yes, BannersStatuspostmoderate.Yes, ImagesStatusmoderate.No, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.Sent, BannersStatuspostmoderate.Yes, ImagesStatusmoderate.No, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, ImagesStatusmoderate.No, StatusEnum.REJECTED, StatusClarification.REJECTED},
                {BannersStatusmoderate.No, BannersStatuspostmoderate.No, ImagesStatusmoderate.Yes, StatusEnum.REJECTED, StatusClarification.REJECTED},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        adId = api.userSteps.adsSteps().addDefaultMobileAppImageAd(adGroupId, adImageHash);

        jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(client);
    }


    @Before
    public void prepareData() {
        jooqDbSteps.bannersSteps().updateBanners(
                new BannersRecord()
                        .setBid(adId)
                        .setStatusmoderate(bannerStatusModerate)
                        .setStatuspostmoderate(bannerStatusPostModerate)
        );
        BannersRecord bannersRecord = jooqDbSteps.bannersSteps().getBanner(adId);
        assumeThat("установился правильный statusModerate у объявления", bannersRecord.getStatusmoderate(), equalTo(bannerStatusModerate));
        assumeThat("установился правильный statusPostModerate у объявления", bannersRecord.getStatuspostmoderate(), equalTo(bannerStatusPostModerate));
        jooqDbSteps.imagesSteps().setImageStatusModerate(adId, adImageHash, imageAdStatusModerate);
        assumeThat("установился правильный statusModerate у изображения",
                jooqDbSteps.imagesSteps().getImagesRecords(campaignId, adGroupId, adId).getStatusmoderate(),
                equalTo(imageAdStatusModerate));
    }

    @Test
    public void getAdAndCheckStatusAndStatusClarification() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATUS_CLARIFICATION)
        );
        assertThat("вернулись правильные Status и StatusClarification объявления",
                getResponse.getAds(), beanDifferV5(
                        Arrays.asList((AdGetItem) new AdGetItemMap()
                                .withId(adId)
                                .withStatus(expectedStatus)
                                .withStatusClarification(expectedStatusClarification.getStatusClarification()).getBean())));
    }

    @Test
    public void getAdByStatus() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap()
                                .withIds(adId)
                                .withStatuses(expectedStatus.toString())
                ).withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATUS, AdFieldEnum.STATUS_CLARIFICATION)
        );
        assertThat("успешно получили объявление по статусу модерации",
                getResponse.getAds(),
                beanEquivalentV5(
                        Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).getBean())
                )
        );
    }

}
