package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdCategoryEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 28.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля AdCategories в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@RunWith(Parameterized.class)
public class AdCategoriesTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameterized.Parameter(0)
    public ModerationFlag moderationFlag;

    @Parameterized.Parameter(1)
    public AdCategoryEnum expectedAdCategories;

    @Parameterized.Parameters(name = "moderationFlag = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {ModerationFlag.ABORTION, AdCategoryEnum.ABORTION},

                //DIRECT-49948
                {ModerationFlag.MEDICINE, AdCategoryEnum.MEDICINE},
                {ModerationFlag.MED_SERVICES, AdCategoryEnum.MEDICINE},
                {ModerationFlag.MED_EQUIPMENT, AdCategoryEnum.MEDICINE},
                {ModerationFlag.PHARMACY, AdCategoryEnum.MEDICINE},

                {ModerationFlag.ALCOHOL, AdCategoryEnum.ALCOHOL},
                {ModerationFlag.TOBACCO, AdCategoryEnum.TOBACCO},
                {ModerationFlag.DIETARY_SUPPL, AdCategoryEnum.DIETARY_SUPPLEMENTS},
                {ModerationFlag.PSEUDO_WEAPON, AdCategoryEnum.PSEUDO_WEAPON},
                {ModerationFlag.TRAGIC, null},
                {ModerationFlag.ADULT, null},
                {ModerationFlag.BABY_FOOD_0, AdCategoryEnum.BABY_FOOD},
                {ModerationFlag.AGE_0, null},
                {ModerationFlag.FOREX, null},
                {ModerationFlag.PROJECT_DECLARATION, AdCategoryEnum.PROJECT_DECLARATION}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().setBannerFlags(adId, moderationFlag);
    }

    @Test
    public void getAdCategories() {
        //DIRECT-42057
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_CATEGORIES));
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withAdCategories(expectedAdCategories).getBean())));
    }
}
