package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 22.06.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса AdImageModeration в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@RunWith(Parameterized.class)
public class AdImageModerationStatusTest {

    private static String client = AdsLogins.CLIENT16;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;

    @Parameter(0)
    public String statusModerate;

    @Parameter(1)
    public StatusEnum expectedStatus;

    @Parameter(2)
    public StatusClarification expectedStatusClarification;

    @Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NEW, StatusEnum.DRAFT, StatusClarification.DRAFT},
                {Status.SENT, StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.SENDING, StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.READY, StatusEnum.MODERATION, StatusClarification.IMAGE_AWAITING_MODERATION},
                {Status.NO, StatusEnum.REJECTED, StatusClarification.IMAGE_REJECTED},
                {Status.YES, StatusEnum.ACCEPTED, StatusClarification.IMAGE_ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        String adImageHash = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1)[0];
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withAdImageHash(adImageHash)).withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setImageStatusModerate(adId, statusModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("картинке установился правильный StatusModerate",
                bannerFakeInfo.getImageStatusModerate(), equalTo(statusModerate));
    }

    @Test
    public void getAd() {
        //DIRECT-42945
        //DIRECT-42847
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                        .withAdImageModerationStatuses(ExtensionStatusSelectionEnum.fromValue(expectedStatus.value()))
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.AD_IMAGE_MODERATION));
        assertThat("вернулся правильный Status в AdImageModeration", getResponse.getAds(), beanEquivalentV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withAdImageModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(expectedStatus)
                                                .withStatusClarification(
                                                        expectedStatusClarification.getStatusClarification())
                                )).getBean())));
    }
}
