package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerDisplayHrefsStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 07.04.16.
 * https://st.yandex-team.ru/TESTIRT-8931
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса DisplayUrlPathModeration в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-52434")
@RunWith(Parameterized.class)
public class DisplayUrlPathModerationStatusTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameter(0)
    public BannerDisplayHrefsStatusmoderate statusModerate;

    @Parameter(1)
    public StatusEnum expectedStatus;

    @Parameter(2)
    public StatusClarification expectedStatusClarification;

    @Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BannerDisplayHrefsStatusmoderate.Sent, StatusEnum.MODERATION, StatusClarification.DISPLAY_URL_PATH_AWAITING_MODERATION},
                {BannerDisplayHrefsStatusmoderate.Sending, StatusEnum.MODERATION, StatusClarification.DISPLAY_URL_PATH_AWAITING_MODERATION},
                {BannerDisplayHrefsStatusmoderate.Ready, StatusEnum.MODERATION, StatusClarification.DISPLAY_URL_PATH_AWAITING_MODERATION},
                {BannerDisplayHrefsStatusmoderate.No, StatusEnum.REJECTED, StatusClarification.DISPLAY_URL_PATH_REJECTED},
                {BannerDisplayHrefsStatusmoderate.Yes, StatusEnum.ACCEPTED, StatusClarification.DISPLAY_URL_PATH_ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdsLogins.CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withDisplayUrlPath(TextAdAddMap.DEFAULT_DISPLAY_URL_PATH)
                        )
                        .withAdGroupId(adGroupId)
        );
        jooqDbSteps.bannerDisplayHrefsSteps().updateStatusModeration(adId, statusModerate);
    }

    @Test
    public void getAd() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.DISPLAY_URL_PATH_MODERATION));
        assertThat("вернулся правильный Status в DisplayUrlPathModeration", getResponse.getAds(), beanDifferV5(
                Collections.singletonList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withDisplayUrlPathModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(expectedStatus)
                                                .withStatusClarification(
                                                        expectedStatusClarification.getStatusClarification())
                                )).getBean())));
    }
}
