package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.yandex.direct.api.v5.ads.AgeLabelEnum.AGE_0;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.AGE_12;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.AGE_16;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.AGE_18;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.AGE_6;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_0;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_1;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_10;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_11;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_12;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_2;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_3;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_4;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_5;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_6;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_7;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_8;
import static com.yandex.direct.api.v5.ads.AgeLabelEnum.MONTHS_9;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка значений флага age и baby_food")
@Issue("https://st.yandex-team.ru/DIRECT-112471, https://st.yandex-team.ru/DIRECT-121098")
@RunWith(Parameterized.class)
public class FlagsTest {

    private static final String CLIENT = AdsLogins.CLIENT8;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String flagValue;

    @Parameterized.Parameter(1)
    public AgeLabelEnum expectedFlag;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(
                new Object[]{"age:age0", AGE_0},
                new Object[]{"age:age6", AGE_6},
                new Object[]{"age:age12", AGE_12},
                new Object[]{"age:age16", AGE_16},
                new Object[]{"age:age18", AGE_18},
                new Object[]{"baby_food:baby_food0", MONTHS_0},
                new Object[]{"baby_food:baby_food1", MONTHS_1},
                new Object[]{"baby_food:baby_food2", MONTHS_2},
                new Object[]{"baby_food:baby_food3", MONTHS_3},
                new Object[]{"baby_food:baby_food4", MONTHS_4},
                new Object[]{"baby_food:baby_food5", MONTHS_5},
                new Object[]{"baby_food:baby_food6", MONTHS_6},
                new Object[]{"baby_food:baby_food7", MONTHS_7},
                new Object[]{"baby_food:baby_food8", MONTHS_8},
                new Object[]{"baby_food:baby_food9", MONTHS_9},
                new Object[]{"baby_food:baby_food10", MONTHS_10},
                new Object[]{"baby_food:baby_food11", MONTHS_11},
                new Object[]{"baby_food:baby_food12", MONTHS_12}
        );
    }

    private static Long adId;

    private static DirectJooqDbSteps jooqSteps;

    @BeforeClass
    public static void initTest() {
        jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void getBannerWithFlagTest() {
        BannersRecord bannersRecord = jooqSteps.bannersSteps().getBanner(adId);
        bannersRecord.setFlags(flagValue);
        jooqSteps.bannersSteps().updateBanners(bannersRecord);

        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.values())
                .withTextAdFieldNames(TextAdFieldEnum.values()));

        assertThat(getResponse.getAds(), hasSize(1));
        assertThat(getResponse.getAds().get(0).getAgeLabel().getValue(), is(expectedFlag));
    }
}
