package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersAdditionsAdditionsType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 09.12.16.
 * https://st.yandex-team.ru/TESTIRT-10642
 */
@Aqua.Test
@Description("Проверка корректности работы метода при наличии дисклеймера у клиента")
@Issue("https://st.yandex-team.ru/DIRECT-59010")
@Features(AdsFeatures.GET)
public class GetTextAdDisclaimerTest {
    private static Long disclaimerId;
    private static int shardId;
    private static Long adExtensionId;
    private static Long campaignId;
    private static Long adGroupId;
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareData() {
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        disclaimerId = api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().saveAdditionsItemDisclaimers(
                        Long.parseLong(User.get(LOGIN).getClientID()),
                        RandomStringUtils.randomAlphanumeric(24));
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(RandomStringUtils.randomAlphabetic(8), LOGIN);
        AddResponse textAd = api.userSteps.adsSteps().shouldGetResultOnAdd(
                new AddRequestMap()
                        .withAds(new AdAddItemMap()
                                .withTextAd(
                                        new TextAdAddMap().defaultTextAd()
                                                .withAdExtensionIds(adExtensionId))
                                .withAdGroupId(adGroupId)),
                LOGIN,
                ExpectedResult.success());
        assumeThat("добавлено 1 объявление", textAd.getAddResults(), hasSize(1));
        adId = textAd.getAddResults().get(0).getId();
        api.userSteps.getDirectJooqDbSteps().useShard(shardId).bannerAdditionsSteps().saveBannerAdditions(
                                adId,
                                disclaimerId,
                                BannersAdditionsAdditionsType.disclaimer);

    }

    @Test
    public void successGetAdWithDisclaimer() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_EXTENSIONS
                ));
        assumeThat("получено 1 объявление", getResponse.getAds(), hasSize(1));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))

                        ).getBean())));
    }


    @Test
    public void tryGetAdByDisclaimerId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                        .withAdExtensionIds(disclaimerId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_EXTENSIONS
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), hasSize(0));
    }

    @AfterClass
    public static void deleteDisclaimer(){
        api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannerAdditionsSteps().deleteAdditionsItemDisclaimers(disclaimerId);
    }
}

