package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdExtensionAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphabetic;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-5331
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка соответствия возвращаемых полей, указанным в TextAdFieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
public class TextAdFieldNamesTest {

    private static String client = AdsLogins.CLIENT7;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;
    static String adImageHash;
    static Long sitelinkSetId;
    static Long vCardId;
    static Long adExtensionId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adImageHash = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1)[0];
        sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId.longValue());
        adExtensionId = api.userSteps.adExtensionsSteps().addCalloutWithText(randomAlphabetic(15));
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap()
                        .defaultTextAd()
                        .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                        .withAdImageHash(adImageHash)
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinkSetId)
                        .withAdExtensionIds(adExtensionId))
                .withAdGroupId(adGroupId));
    }

    @Test
    public void getAdWithAllTextAdFieldNames() {
        //DIRECT-41119
        //DIRECT-42191
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_IMAGE_HASH,
                        TextAdFieldEnum.DISPLAY_DOMAIN,
                        TextAdFieldEnum.HREF,
                        TextAdFieldEnum.SITELINK_SET_ID,
                        TextAdFieldEnum.AD_EXTENSIONS,
                        TextAdFieldEnum.TEXT,
                        TextAdFieldEnum.TITLE,
                        TextAdFieldEnum.TITLE_2,
                        TextAdFieldEnum.V_CARD_ID,
                        TextAdFieldEnum.AD_IMAGE_MODERATION,
                        TextAdFieldEnum.SITELINKS_MODERATION,
                        TextAdFieldEnum.V_CARD_MODERATION,
                        TextAdFieldEnum.MOBILE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                                .withTitle2(TextAdGetMap.TITLE_2)
                                .withHref(TextAdAddMap.DEFAULT_HREF)
                                .withDisplayDomain(TextAdAddMap.DEFAULT_DOMAIN)
                                .withVCardId(vCardId)
                                .withAdImageHash(adImageHash)
                                .withSitelinkSetId(sitelinkSetId)
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.DRAFT)
                                                .withStatusClarification(
                                                        StatusClarification.DRAFT.getStatusClarification()))
                                .withSitelinksModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withAdImageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                                .withMobile(YesNoEnum.NO)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_IMAGE_HASH
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withAdImageHash(adImageHash)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyDisplayDomain() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.DISPLAY_DOMAIN
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withDisplayDomain(TextAdAddMap.DEFAULT_DOMAIN)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyHref() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.HREF
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withHref(TextAdAddMap.DEFAULT_HREF)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlySitelinksSetId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.SITELINK_SET_ID
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withSitelinkSetId(sitelinkSetId)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdExtensionIds() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_EXTENSIONS
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withAdExtensions(new AdExtensionAdGetItemMap()
                                        .withAdExtensionId(adExtensionId)
                                        .withType(AdExtensionTypeEnum.CALLOUT))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyText() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.TEXT
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withText(TextAdAddMap.DEFAULT_TEXT)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyTitle() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.TITLE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withTitle(TextAdAddMap.DEFAULT_TITLE)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyTitle2() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.TITLE_2
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withTitle2(TextAdAddMap.DEFAULT_TITLE_2)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyVCardId() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.V_CARD_ID
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withVCardId(vCardId)
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyAdImageModeration() {
        //DIRECT-42334
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.AD_IMAGE_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withAdImageModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlySitelinksModeration() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.SITELINKS_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withSitelinksModeration(new ExtensionModerationMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withStatusClarification(
                                                StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyVCardModeration() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.V_CARD_MODERATION
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(StatusEnum.DRAFT)
                                                .withStatusClarification(
                                                        StatusClarification.DRAFT.getStatusClarification()))
                        ).getBean())));
    }

    @Test
    public void getAdWithOnlyMobile() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(
                        TextAdFieldEnum.MOBILE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withMobile(YesNoEnum.NO)
                        ).getBean())));
    }
}
