package ru.yandex.autotests.direct.api.ads.get.textad;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.ExtensionStatusSelectionEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdGetMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 21.06.15.
 * https://st.yandex-team.ru/TESTIRT-5226
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка статуса VCardModeration в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-34556")
@RunWith(Parameterized.class)
public class VCardModerationStatusTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameter(1)
    public StatusEnum expectedStatus;

    @Parameterized.Parameter(2)
    public StatusClarification expectedStatusClarification;

    @Parameterized.Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.NEW, StatusEnum.DRAFT, StatusClarification.DRAFT},
                {Status.SENT, StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.SENDING, StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.READY, StatusEnum.MODERATION, StatusClarification.CONTACT_INFO_AWAITING_MODERATION},
                {Status.NO, StatusEnum.REJECTED, StatusClarification.CONTACT_INFO_REJECTED},
                {Status.YES, StatusEnum.ACCEPTED, StatusClarification.CONTACT_INFO_ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap().withTextAd(
                new TextAdAddMap().defaultTextAd().withVCardId(vCardId)).withAdGroupId(adGroupId));
        api.userSteps.bannersFakeSteps().setPhoneflag(adId, statusModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("визитке установился правильный StatusModerate",
                bannerFakeInfo.getPhoneFlag(), equalTo(statusModerate));
    }

    @Test
    public void getAd() {
        //DIRECT-42945
        //DIRECT-42847
        //DIRECT-43128
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                        .withVCardModerationStatuses(ExtensionStatusSelectionEnum.fromValue(expectedStatus.value()))
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.V_CARD_MODERATION));
        assertThat("вернулся правильный Status в VCardModeration", getResponse.getAds(), beanEquivalentV5(
                Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId)
                        .withTextAd(new TextAdGetMap()
                                .withVCardModeration(
                                        new ExtensionModerationMap()
                                                .withStatus(expectedStatus)
                                                .withStatusClarification(expectedStatusClarification.getStatusClarification())
                                )).getBean())));
    }
}
