package ru.yandex.autotests.direct.api.ads.get.textad.videoextension;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.VideoExtensionGetItem;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.VideoExtensionGetItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 20.06.17.
 * https://st.yandex-team.ru/DIRECT-65827
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка полей VideoExtension в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-62100")
@RunWith(Parameterized.class)
public class VideoExtensionPositiveTest {
    private static String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adId;
    private static Long adGroupId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public TextAdAddMap addMap;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        int shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShard(shardId).perfCreativesSteps().saveDefaultVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        Object[][] data = new Object[][]{
                {"объявление с CreativeId", new TextAdAddMap()
                        .defaultTextAd()
                        .withVideoExtension(creativeId)},
               /* ToDo ждет DIRECT-67023
                {"объявление с GenerateAutomatically = YES", new TextAdAddMap()
                        .defaultTextAd()
                        .withVideoExtension(
                            new VideoExtensionAddItemMap()
                                    .withGenerateAutomatically(YesNoEnum.YES))}*/
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCamp(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

    }

    @Before
    public void addAd() {
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(addMap)
                        .withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getVideoExtension() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.VIDEO_EXTENSION)
        );
        assumeThat("вернулось объявление", getResponse.getAds(), hasSize(1));
        VideoExtensionGetItem expectedVideo = (VideoExtensionGetItem)
                                new VideoExtensionGetItemMap()
                                        .withStatus(StatusEnum.DRAFT)
                                        .withCreativeId(0L)
                                        .withPreviewUrl("")
                                        .withThumbnailUrl("").getBean();
        MatchVariation variation = new DefaultMatchVariation().forClasses(Long.class, String.class).useMatcher(notNullValue());
        assertThat("вернулся ожидаемый VideoExtension",
                getResponse.getAds().get(0).getTextAd().getVideoExtension().getValue(),
                beanDifferV5(expectedVideo).withVariation(variation));
    }
}


