package ru.yandex.autotests.direct.api.ads.get.textad.videoextension;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PerfCreativesRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 20.06.17.
 * https://st.yandex-team.ru/DIRECT-65827
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка поля VideoExtension.Status в ответе Ads.get")
@Issue("https://st.yandex-team.ru/DIRECT-62100")
@RunWith(Parameterized.class)
public class VideoExtensionStatusTest {

    private static Long adId;
    private static String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shardId;
    private static Long creativeId;
    private static Long campaignId;
    private static Long adGroupId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public BannersPerformanceStatusmoderate statusModerate;

    @Parameterized.Parameter(1)
    public StatusEnum expectedStatus;

    @Parameterized.Parameters(name = "statusModerate = {0}, expectedStatus = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BannersPerformanceStatusmoderate.New, StatusEnum.DRAFT},
                {BannersPerformanceStatusmoderate.Sent, StatusEnum.MODERATION},
                {BannersPerformanceStatusmoderate.Sending, StatusEnum.MODERATION},
                {BannersPerformanceStatusmoderate.Ready, StatusEnum.MODERATION},
                {BannersPerformanceStatusmoderate.No, StatusEnum.REJECTED},
                {BannersPerformanceStatusmoderate.Yes, StatusEnum.ACCEPTED}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCamp(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        shardId = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShard(shardId).perfCreativesSteps().saveDefaultVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVideoExtension(creativeId)
                        )
                        .withAdGroupId(adGroupId)
        );
    }

    @Before
    public void setStatus() {
        api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .bannersPerformanceSteps().setCreativeStatusModerate(campaignId, adGroupId, adId, statusModerate);
    }

    @Test
    public void getAd() {
        PerfCreativesRecord perf = api.userSteps.getDirectJooqDbSteps().useShard(shardId)
                .perfCreativesSteps().getPerfCreatives(creativeId);
        System.out.println(JsonUtils.toString(perf.getStatusmoderate()));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap()
                        .withIds(adId)
                )
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdFieldNames(TextAdFieldEnum.VIDEO_EXTENSION)
        );
        assumeThat("получено 1 объявление", getResponse.getAds(), hasSize(1));
        assumeThat("получен VideoExtension", getResponse.getAds().get(0).getTextAd().getVideoExtension().getValue(), notNullValue());
        assertThat("вернулся правильный Status в VideoExtension",
                getResponse.getAds().get(0).getTextAd().getVideoExtension().getValue().getStatus(),
                equalTo(expectedStatus));
    }
}

