package ru.yandex.autotests.direct.api.ads.get.textadbuilderad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка работы поля TextAdBuilderAdFieldNames")
public class GetTexAdBuilderAdFieldNamesTest {

    private static String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withTextAdBuilderAd(
                        new TextAdBuilderAdAddMap().defaultTextAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdWithAllTextAdBuilderAdFieldNames() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdBuilderAdFieldNames(TextAdBuilderAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAdBuilderAd(new TextAdBuilderAdGetMap()
                                .withHref(TextAdBuilderAdAddMap.DEFAULT_HREF)
                                .withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withCreativeId(creativeId))
                                .withTurboPageId(null)
                                .withTurboPageModeration(null)
                        ).getBean())));
    }

    @Test
    public void getAdWithAdCreativeIdOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdBuilderAdFieldNames(
                        TextAdBuilderAdFieldEnum.CREATIVE
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAdBuilderAd(new TextAdBuilderAdGetMap()
                                .withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withCreativeId(creativeId))
                        ).getBean())));
    }

    @Test
    public void getAdWithHrefOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextAdBuilderAdFieldNames(
                        TextAdBuilderAdFieldEnum.HREF
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAdBuilderAd(new TextAdBuilderAdGetMap()
                                .withHref(TextAdBuilderAdAddMap.DEFAULT_HREF)
                        ).getBean())));
    }

}
