package ru.yandex.autotests.direct.api.ads.get.textadbuilderad;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdBuilderAdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdBuilderAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * https://st.yandex-team.ru/DIRECT-71573
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка выборки текстовых графических объявлений по Creative")
@Issue("https://st.yandex-team.ru/DIRECT-58369")
public class GetTextAdBuilderAdTest {
    private static String CLIENT = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long adGroupId;
    private static Long campaignId;
    private static Long creativeId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
        creativeId = jooqDbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(CLIENT).getClientID()));

        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withTextAdBuilderAd(
                        new TextAdBuilderAdAddMap().defaultTextAdBuilderAd(creativeId)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdByAdIdAndCreative() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId)
                ).withTextAdBuilderAdFieldNames(TextAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Arrays.asList((AdGetItem)
                        new AdGetItemMap()
                                .withId(adId)
                                .withTextAdBuilderAd(
                                        new TextAdBuilderAdGetMap().withCreative(
                                                new AdBuilderAdGetItemMap()
                                                    .withCreativeId(creativeId)
                                                    .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                    .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                        ))
                                .getBean())));
    }

    @Test
    public void getAdByAdGroupIdAndCreative() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withAdGroupIds(adGroupId)
                ).withTextAdBuilderAdFieldNames(TextAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAdBuilderAd(
                                new TextAdBuilderAdGetMap().withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withCreativeId(creativeId)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                ))
                        .getBean())));
    }

    @Test
    public void getAdByCampaignIdAndCreative() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withCampaignIds(campaignId)
                ).withTextAdBuilderAdFieldNames(TextAdBuilderAdFieldEnum.CREATIVE)
                        .withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(),
                beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextAdBuilderAd(
                                new TextAdBuilderAdGetMap().withCreative(
                                        new AdBuilderAdGetItemMap()
                                                .withCreativeId(creativeId)
                                                .withPreviewUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                                .withThumbnailUrl(AdBuilderAdGetItemMap.DEFAULT_URL)
                                ))
                        .getBean())));
    }

}
