package ru.yandex.autotests.direct.api.ads.get.textimagead;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;

/**
 * Created by gerdler on 12.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("Проверка выборки текстовых графических объявлений по AdImageHash")
@Issue("https://st.yandex-team.ru/DIRECT-54753")
public class GetTextImageAdByAdImageHashTest {
    private static String client = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static Long adGroupId;
    private static Long campaignId;
    private static String adImageHash;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(2);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withTextImageAd(
                        new TextImageAdAddMap().defaultTextImageAd(adImageHash)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdByAdIdAndAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId).withAdImageHashes(adImageHash)
                ).withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).getBean())));
    }

    @Test
    public void getAdByAdGroupIdAndAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withAdGroupIds(adGroupId).withAdImageHashes(adImageHash)
                ).withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).getBean())));
    }

    @Test
    public void getAdByCampaignIdAndAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withCampaignIds(campaignId).withAdImageHashes(adImageHash)
                ).withFieldNames(AdFieldEnum.ID)
        );
        assertThat("вернулось правильное объявление", getResponse.getAds(), beanDifferV5(Arrays.asList((AdGetItem) new AdGetItemMap().withId(adId).getBean())));
    }

    @Test
    public void getNoneByIdAndInvalidAdImageHash() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(
                new GetRequestMap().withSelectionCriteria(
                        new AdsSelectionCriteriaMap().withIds(adId).withAdImageHashes(RandomStringUtils.randomAlphabetic(8))
                ).withFieldNames(AdFieldEnum.ID)
        );
        assertThat("не вернулось ни одного объявления", getResponse.getAds(), hasSize(0));
    }

}
