package ru.yandex.autotests.direct.api.ads.get.textimagead;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.TextImageAdFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;

/**
 * Created by gerdler on 10.07.16.
 * https://st.yandex-team.ru/TESTIRT-9322
 */
@Aqua.Test
@Features(AdsFeatures.GET)
@Description("проверка работы поля TextImageAdFieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-54753")
public class GetTextImageAdFieldNamesTest {

    private static String client = AdsLogins.CLIENT43;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;
    private static String adImageHash;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);

        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(5);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap().withTextImageAd(
                        new TextImageAdAddMap().defaultTextImageAd(adImageHash)
                ).withAdGroupId(adGroupId)
        );
    }

    @Test
    public void getAdWithAllTextImageAdFieldNames() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextImageAdFieldNames(TextImageAdFieldEnum.values()));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextImageAd(new TextImageAdGetMap()
                                .withHref(TextImageAdAddMap.DEFAULT_HREF)
                                .withAdImageHash(adImageHash)
                                .withTurboPageId(null)
                                .withTurboPageModeration(null)
                        ).getBean())));
    }

    @Test
    public void getAdWithAdImageHashOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextImageAdFieldNames(
                        TextImageAdFieldEnum.AD_IMAGE_HASH
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextImageAd(new TextImageAdGetMap()
                                .withAdImageHash(adImageHash)
                        ).getBean())));
    }

    @Test
    public void getAdWithHrefOnly() {
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID)
                .withTextImageAdFieldNames(
                        TextImageAdFieldEnum.HREF
                ));
        assertThat("вернулось объявление с правильным набором полей", getResponse.getAds(), beanDifferV5(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withTextImageAd(new TextImageAdGetMap()
                                .withHref(TextImageAdAddMap.DEFAULT_HREF)
                        ).getBean())));
    }

}
